/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.internal.mllib.SupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.mllib.EdgeWiseModel;
import oracle.pgx.api.mllib.FileModelStorer;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWisePredictionLayerConfig;
import oracle.pgx.config.mllib.ModelKind;
import oracle.pgx.config.mllib.SupervisedEdgeWiseModelConfig;
import oracle.pgx.config.mllib.loss.LossFunction;

public class SupervisedEdgeWiseModel
extends EdgeWiseModel<SupervisedEdgeWiseModelConfig, SupervisedEdgeWiseModelMetadata, SupervisedEdgeWiseModel> {
    public static final String ALGORITHM_NAME = "SupervisedEdgeWise";

    public SupervisedEdgeWiseModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor, SupervisedEdgeWiseModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier, modelMetadata, graphConstructor);
    }

    public SupervisedEdgeWiseModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor, ModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier, null, graphConstructor);
        if (modelMetadata.getModelKind() != this.getModelKind()) {
            ErrorMessages.throwException(IllegalArgumentException::new, (String)"UNEXPECTED_MODEL_KIND", (Object[])new Object[]{this.getModelKind(), modelMetadata.getModelKind()});
        } else {
            this.modelMetadata = (SupervisedEdgeWiseModelMetadata)modelMetadata;
        }
    }

    @Override
    protected SupervisedEdgeWiseModel getThis() {
        return this;
    }

    @Override
    protected ModelKind getModelKind() {
        return ModelKind.SUPERVISED_EDGEWISE;
    }

    @Override
    public PgxFuture<Double> fitAsync(PgxGraph graph) {
        return this.core.fitSupervisedEdgeWiseModel(this.session.getSessionContext(), ((SupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId()).thenApply(metadata -> {
            this.modelMetadata = metadata;
            return ((SupervisedEdgeWiseModelConfig)metadata.getConfig()).getTrainingLoss();
        });
    }

    @Override
    public PgxFuture<PgxFrame> inferEmbeddingsAsync(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.core.inferEmbeddingsSupervisedEdgeWiseModel(this.session.getSessionContext(), ((SupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeEdges(edges)).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFuture<PgxFrame> inferLogitsAsync(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.core.inferLogitsSupervisedEdgeWiseModel(this.session.getSessionContext(), ((SupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeEdges(edges)).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame inferLogits(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.inferLogitsAsync(graph, edges).join();
    }

    public PgxFuture<PgxFrame> inferLabelsAsync(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.inferLabelsAsync(graph, edges, 0.0f);
    }

    public PgxFuture<PgxFrame> inferLabelsAsync(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.core.inferLabelsSupervisedEdgeWiseModel(this.session.getSessionContext(), ((SupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeEdges(edges), threshold).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFuture<PgxFrame> evaluateLabelsAsync(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.evaluateLabelsAsync(graph, edges, 0.0f);
    }

    public PgxFuture<PgxFrame> evaluateLabelsAsync(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.core.evaluateLabelsSupervisedEdgeWiseModel(this.session.getSessionContext(), ((SupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeEdges(edges), threshold).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame inferLabels(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.inferLabelsAsync(graph, edges, 0.0f).join();
    }

    public PgxFrame inferLabels(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.inferLabelsAsync(graph, edges, threshold).join();
    }

    public PgxFrame evaluateLabels(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.evaluateLabelsAsync(graph, edges, 0.0f).join();
    }

    public PgxFrame evaluateLabels(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.evaluateLabelsAsync(graph, edges, threshold).join();
    }

    public PgxFuture<PgxFrame> inferAsync(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.inferAsync(graph, edges, 0.0f);
    }

    public PgxFuture<PgxFrame> inferAsync(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.core.inferSupervisedEdgeWiseModel(this.session.getSessionContext(), ((SupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeEdges(edges), threshold).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFuture<PgxFrame> evaluateAsync(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.evaluateAsync(graph, edges, 0.0f);
    }

    public PgxFuture<PgxFrame> evaluateAsync(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.core.evaluateSupervisedEdgeWiseModel(this.session.getSessionContext(), ((SupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeEdges(edges), threshold).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFrame infer(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.inferAsync(graph, edges, 0.0f).join();
    }

    public PgxFrame infer(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.inferAsync(graph, edges, threshold).join();
    }

    public PgxFrame evaluate(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.evaluateAsync(graph, edges, 0.0f).join();
    }

    public PgxFrame evaluate(PgxGraph graph, Iterable<PgxEdge> edges, float threshold) {
        return this.evaluateAsync(graph, edges, threshold).join();
    }

    public PgxFuture<Void> storeAsync(String path, String key) throws ExecutionException, InterruptedException {
        return this.storeAsync(path, key, false);
    }

    public PgxFuture<Void> storeAsync(String path, String key, boolean overwrite) {
        return ((FileModelStorer)this.export().file().path(path).key(key).overwrite(overwrite)).storeAsync();
    }

    public void store(String path, String key) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key).get();
    }

    public void store(String path, String key, boolean overwrite) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key, overwrite).get();
    }

    public LossFunction getLossFunctionClass() {
        return ((SupervisedEdgeWiseModelConfig)this.getConfig()).getLossFunctionClass();
    }

    public GraphWisePredictionLayerConfig[] getPredictionLayerConfigs() {
        return ((SupervisedEdgeWiseModelConfig)this.getConfig()).getPredictionLayerConfigs();
    }

    public Map<?, Float> getClassWeights() {
        return ((SupervisedEdgeWiseModelConfig)this.getConfig()).getClassWeights();
    }

    public String getEdgeTargetPropertyName() {
        return ((SupervisedEdgeWiseModelConfig)this.getConfig()).getEdgeTargetPropertyName();
    }

    public List<Set<String>> getTargetEdgeLabels() {
        return ((SupervisedEdgeWiseModelConfig)this.getConfig()).getTargetEdgeLabelSets();
    }

    public static enum SupervisedEdgeWiseInferenceType {
        INFER_EMBEDDINGS,
        INFER_LABELS,
        EVALUATE_LABELS,
        INFER_LOGITS,
        INFER,
        EVALUATE;

    }
}

