/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import oracle.pgx.api.internal.ElementChanges;
import oracle.pgx.common.util.ChangeTrackingMap;
import oracle.pgx.common.util.ChangeTrackingSet;
import oracle.pgx.common.util.ErrorMessages;

public final class VertexChanges
extends ElementChanges {
    private ChangeTrackingSet<String> labelChanges = new ChangeTrackingSet();
    protected Object elementId;

    private VertexChanges() {
    }

    VertexChanges(Object elementId) {
        this.elementId = elementId;
    }

    public void addLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_LABEL_VALUE", (Object[])new Object[0]));
        }
        this.labelChanges.trackAdd((Object)label);
    }

    public void removeLabel(String label) {
        this.labelChanges.trackRemove((Object)label);
    }

    @Override
    public String toString() {
        return "VertexChanges{" + super.toString() + ", labelChanges=" + this.labelChanges + ", elementId=" + this.elementId + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VertexChanges changes = (VertexChanges)o;
        return Objects.equals(this.labelChanges, changes.labelChanges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.labelChanges);
    }

    public void setId(Object elementId) {
        this.elementId = (Comparable)elementId;
    }

    public Object getId() {
        return this.elementId;
    }

    public List<ChangeTrackingMap.ChangeSetEntry<String, String>> getLabelChanges() {
        return this.labelChanges.getChanges();
    }

    private void setLabelChanges(Collection<ChangeTrackingMap.ChangeSetEntry<String, String>> labelChanges) {
        for (ChangeTrackingMap.ChangeSetEntry<String, String> entry : labelChanges) {
            switch (entry.getChangeType()) {
                case ADD: {
                    this.labelChanges.trackAdd(entry.getKey());
                    break;
                }
                case REMOVE: {
                    this.labelChanges.trackRemove(entry.getKey());
                    break;
                }
            }
        }
    }
}

