/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientConfig
extends AbstractConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientConfig.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientConfig getInstance(Map<ClientConfig.Field, Object> values) {
        try (InputStream is = JsonUtil.toJsonInputStream(values);){
            ClientConfig config = ClientConfig.parse(is, true, null);
            if (LOG.isDebugEnabled()) {
                for (ClientConfig.Field field : ClientConfig.Field.values()) {
                    LOG.debug("[" + field.toKey() + "=" + config.getValues().get((Object)field) + "]");
                }
            }
            ClientConfig clientConfig = config;
            return clientConfig;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getCleanedBaseUrl() {
        String baseUrl = this.getBaseUrl();
        if (!baseUrl.startsWith("http://") && !baseUrl.startsWith("https://")) {
            baseUrl = "https://" + baseUrl;
        }
        if (baseUrl.length() > 0 && baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public abstract String getBaseUrl();
}

