/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.internal.synchronizer.FlashbackConfig;
import oracle.pgx.api.internal.synchronizer.FlashbackConfigBuilder;
import oracle.pgx.api.internal.synchronizer.FlashbackPropertyConfig;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;

public final class FetcherUtils {
    private static final int SCN_EXPIRED_ERROR = 30052;
    private static final int TABLE_OR_VIEW_NOT_EXISTS_ERROR = 942;
    private static final int VERSIONS_CLAUSE_NOT_ALLOWED = 30051;
    private final Long currentScn;

    public FetcherUtils(Long currentScn) {
        this.currentScn = currentScn;
    }

    public FlashbackConfig createFlashbackConfig(PgxGraph g, EntityProviderConfig provider, Long lastScn) {
        RdbmsEntityProviderConfig rdbmsConfig = (RdbmsEntityProviderConfig)provider;
        List<FlashbackPropertyConfig> properties = provider.getProps().stream().map(p -> new FlashbackPropertyConfig((String)p.getColumn(), p.getName())).collect(Collectors.toList());
        return new FlashbackConfigBuilder().setProperties(properties).setTableName(rdbmsConfig.getDatabaseTableName()).setUsername(rdbmsConfig.getUsername()).setGraphName(g.getName()).setStartScn(lastScn).setEndScn(this.currentScn).setKeyColumn(rdbmsConfig.getKeyColumn()).setSourceColumn(rdbmsConfig.getSourceColumn()).setDestinationColumn(rdbmsConfig.getDestinationColumn()).setSchema(rdbmsConfig.getSchema()).build();
    }

    public static void rethrowSqlException(SQLException ex, String tableName) throws SQLException {
        switch (ex.getErrorCode()) {
            case 30051: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"VIEWS_NOT_SUPPORTED", (Object[])new Object[]{tableName}), ex);
            }
            case 30052: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SYNC_SCN_TIMEOUT_EXCEPTION", (Object[])new Object[0]), ex);
            }
            case 942: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"TABLE_OR_VIEW_NOT_EXISTS", (Object[])new Object[]{tableName}), ex);
            }
        }
        throw ex;
    }
}

