/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.expansion;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.expansion.AbstractGraphExpander;
import oracle.pgx.api.expansion.PreparedPgViewPgqlQuery;
import oracle.pgx.api.expansion.internal.GraphExpansionConfig;
import oracle.pgx.api.expansion.internal.PgqlGraphExpansionConfig;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.api.subgraph.internal.PreparedPgqlQueryBuilderImpl;
import oracle.pgx.config.GraphConfigBuilder;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.loaders.location.GraphLocation;
import oracle.pgx.loaders.location.PgViewGraphLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BetaApi
public class PgqlViewGraphExpander
extends AbstractGraphExpander<PgqlViewGraphExpander> {
    private static final Logger LOG = LoggerFactory.getLogger(PgqlViewGraphExpander.class);
    private String pgViewName;
    private final List<String> queries = new ArrayList<String>();
    private final List<PreparedPgqlQueryBuilderImpl> preparedQueries = new ArrayList<PreparedPgqlQueryBuilderImpl>();
    private String jdbcUrl;
    private String dataSourceId;
    private String owner;
    private String username;
    private String password;
    private String keystoreAlias;
    private int numConnections;

    public PgqlViewGraphExpander(PartitionedGraphConfig graphConfig, PgxSession session, Function<GraphExpansionConfig, PgxFuture<PgxGraph>> expansionFunction, KeystoreLookup keystoreLookup) {
        super(graphConfig, session, expansionFunction, keystoreLookup);
    }

    @Override
    protected PgqlViewGraphExpander getThis() {
        return this;
    }

    @Override
    protected PgxFuture<GraphExpansionConfig> buildExpansionConfig(String newGraphName, boolean asSnapshot) {
        PgxFuture<PartitionedGraphConfig> expandCfg;
        LOG.debug("Building expansion config.");
        if (this.expansionConfig != null) {
            LOG.debug("Separate config was provided, using this config.");
            expandCfg = PgxFuture.completedFuture(this.expansionConfig);
        } else if (this.pgViewName != null && !Objects.equals(this.graphConfig.getPgViewName(), this.pgViewName)) {
            LOG.debug("Expanding from different view, using describe graph");
            expandCfg = this.session.describeGraphAsync((GraphLocation)PgViewGraphLocation.fromQualifiedName((String)this.pgViewName, null, (String)this.jdbcUrl, (String)this.username, (String)this.password, (String)this.dataSourceId));
        } else {
            LOG.info("Using base config");
            expandCfg = PgxFuture.completedFuture(this.graphConfig);
        }
        return expandCfg.thenApply(cfg -> {
            ArrayList<PreparedQueryConfig> preparedQueries = new ArrayList<PreparedQueryConfig>();
            for (PreparedPgqlQueryBuilderImpl preparedPgqlQueryBuilder : this.preparedQueries) {
                preparedQueries.add(preparedPgqlQueryBuilder.buildQueryWithArguments());
            }
            assert (cfg instanceof PartitionedGraphConfig);
            PartitionedGraphConfigBuilder configBuilder = GraphConfigBuilder.forPartitioned().copyFrom((PartitionedGraphConfig)cfg);
            if (this.jdbcUrl != null) {
                configBuilder.setJdbcUrl(this.jdbcUrl);
            }
            if (this.dataSourceId != null) {
                configBuilder.setDataSourceId(this.dataSourceId);
            }
            if (this.owner != null) {
                configBuilder.setSchema(this.owner);
            }
            if (this.username != null) {
                configBuilder.setUsername(this.username);
            }
            if (this.password != null) {
                configBuilder.setPassword(this.password);
            }
            if (this.keystoreAlias != null) {
                configBuilder.setKeystoreAlias(this.keystoreAlias);
            }
            if (this.numConnections > 0) {
                configBuilder.setNumConnections(this.numConnections);
            }
            PartitionedGraphConfig newGraphConfig = (PartitionedGraphConfig)configBuilder.build();
            return new PgqlGraphExpansionConfig(newGraphName, this.graphConfig, newGraphConfig, this.queries, (List<PreparedQueryConfig>)preparedQueries, this.pgViewName, asSnapshot, this.vertexPropertyMergeStrategy, this.edgePropertyMergeStrategy);
        });
    }

    public PgqlViewGraphExpander fromPgView(String pgViewName) {
        this.pgViewName = pgViewName;
        return this;
    }

    public PgqlViewGraphExpander queryPgql(String query) {
        this.queries.add(query);
        return this;
    }

    public PreparedPgViewPgqlQuery preparedPgqlQuery(String query) {
        PreparedPgqlQueryBuilderImpl preparedQuery = new PreparedPgqlQueryBuilderImpl(query);
        this.preparedQueries.add(preparedQuery);
        return new PreparedPgViewPgqlQuery(this, preparedQuery);
    }

    public PgqlViewGraphExpander dataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
        return this;
    }

    public PgqlViewGraphExpander jdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public PgqlViewGraphExpander username(String userName) {
        this.username = userName;
        return this;
    }

    public PgqlViewGraphExpander keystoreAlias(String keystoreAlias) {
        try {
            this.password(this.keystoreLookup.getPasswordForAlias(keystoreAlias));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        this.keystoreAlias = keystoreAlias;
        return this;
    }

    public PgqlViewGraphExpander password(String password) {
        this.password = password;
        return this;
    }

    public PgqlViewGraphExpander schema(String schema) {
        this.owner = schema;
        return this;
    }

    public PgqlViewGraphExpander owner(String owner) {
        return this.schema(owner);
    }

    public PgqlViewGraphExpander connections(int numConnections) {
        this.numConnections = numConnections;
        return this;
    }
}

