/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.mllib.Model;
import oracle.pgx.api.mllib.ModelLoader;
import oracle.pgx.config.mllib.DbModelLoadingConfiguration;
import oracle.pgx.config.mllib.ModelKind;
import oracle.pgx.config.mllib.ModelLoadingConfiguration;

public class DbModelLoader<ModelType extends Model<ModelType>>
extends ModelLoader<ModelType, DbModelLoader<ModelType>> {
    private final DbModelLoadingConfiguration loadingConfiguration;

    public DbModelLoader(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, ModelKind modelKind, ModelLoader.ModelConstructor<ModelType> constructor) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier, modelKind, constructor);
        this.loadingConfiguration = new DbModelLoadingConfiguration(modelKind);
    }

    @Override
    protected DbModelLoader<ModelType> getThis() {
        return this;
    }

    public DbModelLoader<ModelType> owner(String owner) {
        this.loadingConfiguration.setOwner(owner);
        return this.getThis();
    }

    public DbModelLoader<ModelType> schema(String schema) {
        return this.owner(schema);
    }

    public DbModelLoader<ModelType> dataSourceId(String dataSourceId) {
        this.loadingConfiguration.setDataSourceId(dataSourceId);
        return this.getThis();
    }

    public DbModelLoader<ModelType> jdbcUrl(String jdbcUrl) {
        this.loadingConfiguration.setJdbcUrl(jdbcUrl);
        return this.getThis();
    }

    public DbModelLoader<ModelType> username(String username) {
        this.loadingConfiguration.setUsername(username);
        return this.getThis();
    }

    public DbModelLoader<ModelType> password(String password) {
        this.loadingConfiguration.setPassword(password);
        return this.getThis();
    }

    public DbModelLoader<ModelType> keystoreAlias(String keystore) {
        this.loadingConfiguration.setKeystoreAlias(keystore);
        return this.getThis();
    }

    public DbModelLoader<ModelType> modelstore(String modelStoreName) {
        this.loadingConfiguration.setModelstore(modelStoreName);
        return this.getThis();
    }

    public DbModelLoader<ModelType> modelname(String modelName) {
        this.loadingConfiguration.setModelname(modelName);
        return this.getThis();
    }

    @Override
    public PgxFuture<ModelType> loadAsync() {
        return this.triggerLoadAsync((ModelLoadingConfiguration)this.loadingConfiguration);
    }
}

