/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.algorithm.arguments;

import java.util.Arrays;
import java.util.Collection;
import oracle.pgx.api.internal.algorithm.arguments.AbstractArguments;

public final class CommunitiesArguments
extends AbstractArguments {
    public static final int MAX_ITERATIONS = 100;
    public static final double TAU = 0.15;
    public static final double TOL = 1.0E-4;
    private static final String DEFAULT_NAME = "conductance_minimization";
    private static final String LABEL_PROPAGATION = "label_propagation";
    private static final String INFOMAP = "infomap";

    public String getDefaultName(CommunitiesVariant variant) {
        switch (variant) {
            case LABEL_PROPAGATION: {
                return LABEL_PROPAGATION;
            }
            case INFOMAP: {
                return INFOMAP;
            }
        }
        return DEFAULT_NAME;
    }

    @Override
    protected Collection<String> getAvailableArgs() {
        return Arrays.asList("graph", "variant", "rank", "weight", "tau", "tol", "maxIterations", "partitionDistribution", "communitiesPartitionName");
    }

    public static enum CommunitiesVariant {
        CONDUCTANCE_MINIMIZATION,
        LABEL_PROPAGATION,
        INFOMAP;

    }
}

