/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.graphalteration.internal;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.graphalteration.GraphAlterationBuilder;
import oracle.pgx.api.graphalteration.GraphAlterationEmptyEdgeProviderBuilder;
import oracle.pgx.api.graphalteration.GraphAlterationEmptyProviderBuilder;
import oracle.pgx.api.graphalteration.GraphAlterationEmptyVertexProviderBuilder;
import oracle.pgx.api.graphalteration.internal.GraphAlterationBuilderImpl;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfigBuilder;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.ProviderFormat;

public abstract class GraphAlterationEmptyProviderBuilderImpl<T extends GraphAlterationEmptyProviderBuilderImpl<?>>
implements GraphAlterationEmptyProviderBuilder {
    private final GraphAlterationBuilderImpl alterationBuilder;
    protected final FileEntityProviderConfigBuilder configBuilder;

    public GraphAlterationEmptyProviderBuilderImpl(GraphAlterationBuilderImpl alterationBuilder, String providerName) {
        this.alterationBuilder = alterationBuilder;
        this.configBuilder = ((FileEntityProviderConfigBuilder)new FileEntityProviderConfigBuilder(ProviderFormat.CSV).setName(providerName)).setUris(new String[]{"dummy.csv"});
    }

    public abstract T getThis();

    public EntityProviderConfig buildProviderConfig() {
        return this.configBuilder.build();
    }

    public T setLabel(String label) {
        this.configBuilder.setLabel(label);
        return this.getThis();
    }

    public T setKeyType(IdType type) {
        this.configBuilder.setKeyType(type);
        return this.getThis();
    }

    public T setKeyColumn(Object column) {
        this.configBuilder.setKeyColumn(column);
        return this.getThis();
    }

    public T createKeyMapping(boolean create) {
        this.configBuilder.createKeyMapping(create);
        return this.getThis();
    }

    public T addProperty(String name, PropertyType type) {
        this.configBuilder.addProperty(name, type);
        return this.getThis();
    }

    public T addProperty(String name, PropertyType type, int dimension) {
        this.configBuilder.addVectorProperty(name, type, dimension);
        return this.getThis();
    }

    public T addProperty(GraphPropertyConfig config) {
        this.configBuilder.addVectorProperty(config.getName(), config.getType(), config.getDimension().intValue(), config.getDefault(), config.getColumn());
        return this.getThis();
    }

    public T addProperties(GraphPropertyConfig[] configs) {
        for (GraphPropertyConfig config : configs) {
            this.addProperty(config);
        }
        return this.getThis();
    }

    public T addProperties(List<GraphPropertyConfig> configs) {
        for (GraphPropertyConfig config : configs) {
            this.addProperty(config);
        }
        return this.getThis();
    }

    @Override
    public void setDataSourceVersion(String version) {
        this.alterationBuilder.setDataSourceVersion(version);
    }

    @Override
    public GraphAlterationBuilder cascadeEdgeProviderRemovals(boolean cascadeEdgeProviderRemovals) {
        return this.alterationBuilder.cascadeEdgeProviderRemovals(cascadeEdgeProviderRemovals);
    }

    @Override
    public GraphAlterationBuilder addVertexProvider(String pathToVertexProviderConfig) throws IOException {
        return this.alterationBuilder.addVertexProvider(pathToVertexProviderConfig);
    }

    @Override
    public GraphAlterationBuilder addVertexProvider(EntityProviderConfig vertexProviderConfig) {
        return this.alterationBuilder.addVertexProvider(vertexProviderConfig);
    }

    @Override
    public GraphAlterationEmptyVertexProviderBuilder addEmptyVertexProvider(String providerName) {
        return this.alterationBuilder.addEmptyVertexProvider(providerName);
    }

    @Override
    public GraphAlterationBuilder removeVertexProvider(String vertexProviderName) {
        return this.alterationBuilder.removeVertexProvider(vertexProviderName);
    }

    @Override
    public GraphAlterationBuilder addEdgeProvider(String pathToEdgeProviderConfig) throws IOException {
        return this.alterationBuilder.addEdgeProvider(pathToEdgeProviderConfig);
    }

    @Override
    public GraphAlterationBuilder addEdgeProvider(EntityProviderConfig edgeProviderConfig) {
        return this.alterationBuilder.addEdgeProvider(edgeProviderConfig);
    }

    @Override
    public GraphAlterationEmptyEdgeProviderBuilder addEmptyEdgeProvider(String providerName, String sourceProvider, String destProvider) {
        return this.alterationBuilder.addEmptyEdgeProvider(providerName, sourceProvider, destProvider);
    }

    @Override
    public GraphAlterationBuilder removeEdgeProvider(String edgeProviderName) {
        return this.alterationBuilder.removeEdgeProvider(edgeProviderName);
    }

    @Override
    public PgxFuture<PgxGraph> buildAsync(String newGraphName) {
        return this.alterationBuilder.buildAsync(newGraphName);
    }

    @Override
    public PgxFuture<PgxGraph> buildAsync() {
        return this.alterationBuilder.buildAsync();
    }

    @Override
    public PgxGraph build(String newGraphName) throws ExecutionException, InterruptedException {
        return this.alterationBuilder.build(newGraphName);
    }

    @Override
    public PgxGraph build() throws ExecutionException, InterruptedException {
        return this.alterationBuilder.build();
    }

    @Override
    public PgxFuture<PgxGraph> buildNewSnapshotAsync() {
        return this.alterationBuilder.buildNewSnapshotAsync();
    }

    @Override
    public PgxGraph buildNewSnapshot() throws ExecutionException, InterruptedException {
        return this.alterationBuilder.buildNewSnapshot();
    }
}

