/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Property;

public class EdgeProperty<V>
extends oracle.pgx.api.Property<Long, PgxEdge, V> {
    public static final Set<EdgeProperty<?>> ALL = null;
    public static final Set<EdgeProperty<?>> NONE = Collections.emptySet();

    EdgeProperty(PgxGraph graph, Property pr) {
        super(graph, pr);
    }

    protected EdgeProperty(PgxGraph graph, Property pr, boolean label) {
        super(graph, pr, label);
    }

    private <V> Function<Property, EdgeProperty<V>> getConstructor() {
        return property -> new EdgeProperty<V>(this.graph, (Property)((Object)property));
    }

    @Override
    protected PgxEdge getEntity(Object keyOrEntity) {
        if (keyOrEntity instanceof Edge) {
            return new PgxEdge(this.getGraph(), (Edge)keyOrEntity);
        }
        return new PgxEdge(this.getGraph(), (Long)keyOrEntity);
    }

    public <S> PgxFuture<List<EdgeProperty<S>>> expandAsync() {
        return this.expandAsync(null);
    }

    public <S> PgxFuture<List<EdgeProperty<S>>> expandAsync(String namePrefix) {
        return this.internalExpand(this.getConstructor(), namePrefix);
    }

    public PgxFuture<EdgeProperty<V>> cloneAsync() {
        return this.cloneAsync(null);
    }

    public PgxFuture<EdgeProperty<V>> cloneAsync(String newPropertyName) {
        return this.internalClone(newPropertyName, this.getConstructor());
    }

    public EdgeProperty<V> clone() {
        try {
            return this.cloneAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public EdgeProperty<V> clone(String newPropertyName) throws ExecutionException, InterruptedException {
        return this.cloneAsync(newPropertyName).get();
    }

    public <S> List<EdgeProperty<S>> expand() throws ExecutionException, InterruptedException {
        return this.expandAsync().get();
    }

    public <S> List<EdgeProperty<S>> expand(String namePrefix) throws ExecutionException, InterruptedException {
        return this.expandAsync(namePrefix).get();
    }
}

