/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.SQLException;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.GraphMetadataHandler;

public class QueryContext {
    public final PgqlConnection pgqlConn;
    public String graphName;
    public String schemaName;
    public int dbVersion;
    public double opgVersion;
    public boolean useIso;
    private int qbIdCntr;
    public GraphType graphType;
    public boolean checkTypes;
    public boolean reversePath;
    public boolean pushSrcHops;
    public boolean pushDstHops;
    public boolean expPathClob;
    public boolean spCreateView;
    public boolean spCreateTable;
    public boolean spStartVC;
    public boolean spEndVC;
    public boolean spPathVC;
    public boolean checkedDbVersion = false;

    private QueryContext(PgqlConnection pgqlConn) {
        this.pgqlConn = pgqlConn;
        this.schemaName = null;
        this.graphName = null;
        this.useIso = false;
        this.qbIdCntr = -1;
        this.graphType = null;
        this.checkTypes = true;
        this.reversePath = true;
        this.pushSrcHops = true;
        this.pushDstHops = false;
        this.expPathClob = true;
        this.spCreateView = false;
        this.spCreateTable = true;
        this.spStartVC = true;
        this.spEndVC = true;
        this.spPathVC = true;
    }

    public static QueryContext getQueryContext(PgqlConnection pgqlConn) {
        return new QueryContext(pgqlConn);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        s.append("     dbVersion=[").append(this.dbVersion).append("]\n");
        s.append("    opgVersion=[").append(this.opgVersion).append("]\n");
        s.append("    schemaName=[").append(this.schemaName).append("]\n");
        s.append("     graphName=[").append(this.graphName).append("]\n");
        s.append("        useIso=[").append(this.useIso).append("]\n");
        s.append("      qbIdCntr=[").append(this.qbIdCntr).append("]\n");
        s.append("     graphType=[").append((Object)this.graphType).append("]\n");
        s.append("    checkTypes=[").append(this.checkTypes).append("]\n");
        s.append("   reversePath=[").append(this.reversePath).append("]\n");
        s.append("   pushSrcHops=[").append(this.pushSrcHops).append("]\n");
        s.append("   pushDstHops=[").append(this.pushDstHops).append("]\n");
        s.append("   expPathClob=[").append(this.expPathClob).append("]\n");
        s.append("  spCreateView=[").append(this.spCreateView).append("]\n");
        s.append(" spCreateTable=[").append(this.spCreateTable).append("]\n");
        s.append("  snSmallTrans=[").append(this.spStartVC).append("]\n");
        s.append("  enSmallTrans=[").append(this.spEndVC).append("]\n");
        s.append("  pcSmallTrans=[").append(this.spPathVC).append("]\n");
        return s.toString();
    }

    public int getNextQbId() {
        ++this.qbIdCntr;
        return this.qbIdCntr;
    }

    boolean updateGraphInfo(String schemaName, String graphName, GraphType createType, boolean isDropStatement) {
        this.schemaName = schemaName;
        this.graphName = graphName;
        boolean pgmCreated = false;
        if (createType == null) {
            if (graphName.equals("PROPERTY_GRAPH_METADATA")) {
                try {
                    pgmCreated = GraphMetadataHandler.graphMetadataInitiator(this.pgqlConn, schemaName);
                    this.graphType = GraphType.PG_VIEWS;
                }
                catch (SQLException e) {
                    this.graphType = null;
                }
            } else {
                this.graphType = PgqlUtils.getGraphType(this.pgqlConn.getJdbcConnection(), schemaName, graphName, true, isDropStatement);
            }
            if (this.graphType == null) {
                throw new PgqlToSqlException("Graph " + schemaName + "." + graphName + " does not exist");
            }
        } else {
            this.graphType = createType;
        }
        return pgmCreated;
    }

    public void checkDbVersion() {
        if (!this.checkedDbVersion) {
            this.dbVersion = DbmsUtils.getDatabaseMajorVersion(this.pgqlConn.getJdbcConnection());
            this.checkedDbVersion = true;
        }
    }

    public boolean sbqJoinWorks() {
        this.checkDbVersion();
        return PgqlUtils.DbFeature.SUBQUERY_PATH_EDGE_JOIN.isSupported(this.dbVersion);
    }

    public boolean isModifySupported() {
        this.checkDbVersion();
        return PgqlUtils.DbFeature.INSERT_UPDATE_DELETE.isSupported(this.dbVersion);
    }

    public boolean isShortestPathCursorSupported() {
        this.checkDbVersion();
        return PgqlUtils.DbFeature.SHORTEST_PATH_CURSOR.isSupported(this.dbVersion);
    }
}

