/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStatement;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbmsUtils {
    private static final Logger ms_log = LoggerFactory.getLogger(DbmsUtils.class);
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final int DEFAULT_PARALLEL = 0;
    protected static final int DEFAULT_DS = 2;
    protected static final int DEFAULT_PARALLEL_PTT = 1;
    protected static final int DEFAULT_MAX_RESULTS = -1;
    public static final int DB_18C = 18;
    public static final int DB_19C = 19;
    public static final int DB_23C = 23;
    public static final int CHUNKS_LENGTH = 3500;
    private static final String END_SP_FUNCTION = "END shortest_path_function;";
    private static final int END_SP_FUNCTION_LENGTH = "END shortest_path_function;".length();
    public static final String END_TMP_WITH = "/* end_tmp_with_clause */";
    private static final int END_TMP_WITH_LENGTH = "/* end_tmp_with_clause */".length();

    public static void quietlyCloseResultSetAndStmt(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("quietlyCloseResultSetAndStmt: close result set");
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("quietlyCloseResultSetAndStmt: done closing statement in final block");
                    }
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    static String getTzOffsetStr(Connection conn) throws SQLException {
        String tzOffsetStr = ((OracleConnection)conn).getSessionTimeZoneOffset();
        if (!tzOffsetStr.startsWith("+") && !tzOffsetStr.startsWith("-")) {
            tzOffsetStr = "+" + tzOffsetStr;
        }
        String sign = tzOffsetStr.substring(0, 1);
        String offset = tzOffsetStr.substring(1);
        if (offset.length() < 5) {
            offset = "0" + offset;
        }
        return sign + offset;
    }

    public static String escapeAndEnquoteLiteral(String str) throws PgqlToSqlException {
        return DbmsUtils.escapeAndEnquoteLiteral(str, true);
    }

    public static String escapeAndEnquoteLiteral(String str, boolean forNVarchar) throws PgqlToSqlException {
        String escStr = forNVarchar ? "n" : "";
        try {
            escStr = escStr + "'" + str.replace("'", "''") + "'";
        }
        catch (Exception ex) {
            throw new PgqlToSqlException("Invalid SQL literal " + str);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("escapeSingleQuotes input=[" + str + "] output=[" + escStr + "]");
        }
        return escStr;
    }

    public static String splitClobInChunks(String longString) {
        String result = "(";
        int idx = 0;
        while (idx + 3500 < longString.length()) {
            String chunk = longString.substring(idx, idx + 3500);
            chunk = DbmsUtils.escapeAndEnquoteLiteral(chunk, false);
            result = result + "to_clob(" + chunk + ") ||";
            idx += 3500;
        }
        result = result + "to_clob(" + DbmsUtils.escapeAndEnquoteLiteral(longString.substring(idx), false) + "))";
        return result;
    }

    public static String enquoteTableName(Connection conn, String tableName) throws SQLException {
        try (OracleStatement ostmt = null;){
            ostmt = (OracleStatement)conn.createStatement();
            String string = ostmt.enquoteIdentifier(tableName, true);
            return string;
        }
    }

    public static String sanitizeGraphOwner(Connection conn, String ownerName) throws SQLException {
        String clnGraphOwner = DbmsUtils.sanitizeIdentifier(conn, ownerName);
        if (!clnGraphOwner.startsWith("\"")) {
            clnGraphOwner = "\"" + clnGraphOwner + "\"";
        }
        return clnGraphOwner;
    }

    public static String sanitizeIdentifier(Connection conn, String identifier) throws SQLException {
        try (OracleStatement ostmt = (OracleStatement)conn.createStatement();){
            String string = ostmt.enquoteIdentifier(identifier, false);
            return string;
        }
    }

    public static boolean hasWithClause(String query) {
        return query != null && (query.startsWith("WITH FUNCTION shortest_path_function") || query.startsWith("WITH tmp"));
    }

    public static StringBuffer getQueryWrapper(String query, int maxResults, int parallel, int dynamicSampling) {
        String hint = DbmsUtils.buildHintString(parallel, dynamicSampling);
        String where = "";
        if (maxResults >= 0) {
            where = "\nWHERE ROWNUM <= " + maxResults;
        }
        StringBuffer wQuery = new StringBuffer();
        if (!hint.equals("") || !where.equals("")) {
            String[] queryArr = new String[]{query};
            String withClause = DbmsUtils.removeWithClause(queryArr);
            wQuery.append(withClause).append("SELECT ").append(hint).append("* FROM(").append(queryArr[0]).append(")").append(where);
        } else {
            wQuery.append(query);
        }
        return wQuery;
    }

    public static String removeWithClause(String[] query) {
        String withClause = "";
        if (DbmsUtils.hasWithClause(query[0])) {
            int endIdx = query[0].indexOf(END_SP_FUNCTION);
            endIdx = endIdx == -1 ? query[0].indexOf(END_TMP_WITH) + END_TMP_WITH_LENGTH : (endIdx += END_SP_FUNCTION_LENGTH);
            withClause = query[0].substring(0, endIdx) + "\n";
            query[0] = query[0].replace(withClause, "");
        }
        return withClause;
    }

    protected static String buildHintString(int parallel, int dynamicSampling) {
        String hint = DbmsUtils.buildHint(parallel, dynamicSampling, false, false);
        if (!hint.equals("")) {
            hint = "/*+ " + hint + "*/ ";
        }
        return hint;
    }

    public static String buildHint(int parallel, int dynamicSampling, boolean append, boolean nologging) {
        String hint = "";
        if (nologging) {
            hint = hint + "nologging ";
        }
        if (parallel > 0) {
            hint = hint + "parallel(" + parallel + ") ";
        }
        if (append) {
            hint = hint + "append ";
        }
        if (dynamicSampling != 2 && dynamicSampling > -1) {
            hint = hint + "dynamic_sampling(" + dynamicSampling + ") ";
        }
        return hint;
    }

    protected static int getDatabaseMajorVersion(Connection conn) {
        int dbVersion;
        try {
            dbVersion = conn.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        return dbVersion;
    }

    public static String getTableForSuffix(Connection conn, String graphSchema, String graphName, String suffix) throws SQLException {
        return DbmsUtils.sanitizeGraphOwner(conn, graphSchema) + "." + DbmsUtils.enquoteTableName(conn, graphName + suffix);
    }

    public static int getParallelSafeValueForPTT(int parallel, List<Object> bindValues) {
        if (bindValues != null && bindValues.size() > 0) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Parallel not safe for PTT, using [1] instead");
            }
            return 1;
        }
        return parallel;
    }
}

