/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgsql;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgSqlDdlExecution {
    private static final Logger ms_log = LoggerFactory.getLogger(PgSqlDdlExecution.class);
    private static PgqlConnection pgqlConn;
    private static String schemaName;
    private static String graphName;
    private static CreatePropertyGraph cpg;
    private static String cpgQuery;

    public PgSqlDdlExecution(PgqlConnection pgqlConnection, String schemaName, String graphName) {
        pgqlConn = pgqlConnection;
        PgSqlDdlExecution.schemaName = schemaName;
        PgSqlDdlExecution.graphName = graphName;
    }

    public static void createPg(CreatePropertyGraph cpg) {
        cpgQuery = PgSqlDdlExecution.translateCPG(cpg);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nCreate statement: " + cpgQuery);
        }
        try (Statement stmt = pgqlConn.getJdbcConnection().createStatement();){
            stmt.execute(cpgQuery);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    public static void dropPg() {
        try (Statement stmt = pgqlConn.getJdbcConnection().createStatement();){
            stmt.execute("DROP PROPERTY GRAPH " + PgqlUtils.printIdentifier((String)schemaName) + "." + PgqlUtils.printIdentifier((String)graphName));
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private static String translateCPG(CreatePropertyGraph cpg) {
        String query = "CREATE PROPERTY GRAPH " + PgqlUtils.printIdentifier((String)schemaName) + "." + PgqlUtils.printIdentifier((String)graphName) + "\n";
        query = query + "VERTEX TABLES ( \n";
        List vts = cpg.getVertexTables();
        for (int i = 0; i < vts.size(); ++i) {
            query = query + "  " + PgSqlDdlExecution.translateElementTables((ElementTable)vts.get(i), false) + PgSqlDdlExecution.getComma(i, vts.size() - 1) + "\n";
        }
        List ets = cpg.getEdgeTables();
        if (ets.size() > 0) {
            query = query + ")\nEDGE TABLES (\n";
            for (int i = 0; i < ets.size(); ++i) {
                query = query + "  " + PgSqlDdlExecution.translateElementTables((ElementTable)ets.get(i), true) + PgSqlDdlExecution.getComma(i, ets.size() - 1) + "\n";
            }
        }
        query = query + ")";
        return query;
    }

    private static String printSchemaQualifiedName(SchemaQualifiedName schemaQualifiedName) {
        if (schemaQualifiedName.getSchemaName() == null) {
            return PgqlUtils.printIdentifier((String)schemaQualifiedName.getName());
        }
        return PgqlUtils.printIdentifier((String)schemaQualifiedName.getSchemaName()) + "." + PgqlUtils.printIdentifier((String)schemaQualifiedName.getName());
    }

    private static String translateElementTables(ElementTable et, boolean isEdgeTable) {
        int i;
        String query = PgSqlDdlExecution.printSchemaQualifiedName(et.getTableName()) + " AS " + PgqlUtils.printIdentifier((String)et.getTableAlias()) + "\n";
        if (et.getKey() != null) {
            query = query + "    KEY(";
            List columnNames = et.getKey().getColumnNames();
            for (i = 0; i < columnNames.size(); ++i) {
                query = query + PgqlUtils.printIdentifier((String)((String)columnNames.get(i))) + PgSqlDdlExecution.getComma(i, columnNames.size() - 1);
            }
            query = query + ")\n";
        }
        if (isEdgeTable) {
            EdgeTable edgeTable = (EdgeTable)et;
            query = query + "    SOURCE " + PgSqlDdlExecution.getSourceDestinationTranslation(edgeTable.getSourceVertexTable(), edgeTable.getEdgeSourceKey(), edgeTable.getSourceVertexKey()) + "\n";
            query = query + "    DESTINATION " + PgSqlDdlExecution.getSourceDestinationTranslation(edgeTable.getDestinationVertexTable(), edgeTable.getEdgeDestinationKey(), edgeTable.getDestinationVertexKey()) + "\n";
        }
        List labels = et.getLabels();
        for (i = 0; i < labels.size(); ++i) {
            Label label = (Label)labels.get(i);
            query = query + "    LABEL " + PgqlUtils.printIdentifier((String)label.getName()) + "\n";
            if (label.isPropertiesAreAllColumns()) {
                query = query + "    PROPERTIES ARE ALL COLUMNS ";
            }
            if (label.getPropertiesAreAllColumnsExcept() != null) {
                query = query + " EXCEPT (";
                query = query + label.getPropertiesAreAllColumnsExcept().stream().map(s -> PgqlUtils.printIdentifier((String)s)).collect(Collectors.joining(", "));
                query = query + ")";
            }
            if (label.getProperties() != null && label.getProperties().size() > 0) {
                query = query + "    PROPERTIES(";
                query = query + label.getProperties().stream().map(s -> PgqlUtils.printIdentifier((String)((QueryExpression.VarRef)s.getValueExpression()).getVariable().getName()) + " AS " + PgqlUtils.printIdentifier((String)s.getPropertyName())).collect(Collectors.joining(", "));
                query = query + ")";
                continue;
            }
            if (label.getProperties() == null || label.getProperties().size() != 0) continue;
            query = query + "    NO PROPERTIES";
        }
        return query;
    }

    private static String getSourceDestinationTranslation(VertexTable vt, Key edgeKey, Key srcDstKey) {
        String query = "";
        if (edgeKey != null) {
            query = query + "KEY(" + PgSqlDdlExecution.getKeyTranslation(edgeKey) + ")";
            query = query + " REFERENCES ";
        }
        query = query + PgqlUtils.printIdentifier((String)vt.getTableAlias());
        if (srcDstKey != null) {
            query = query + " (" + PgSqlDdlExecution.getKeyTranslation(srcDstKey) + ")";
        }
        return query;
    }

    private static String getKeyTranslation(Key key) {
        return key.getColumnNames().stream().map(s -> PgqlUtils.printIdentifier((String)s)).collect(Collectors.joining(", "));
    }

    private static String getComma(int index, int size) {
        if (index != size) {
            return ", ";
        }
        return "";
    }
}

