/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.PathTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.QueryTranslator;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class TranslationInfo {
    private final Map<QueryVariable, List<Pair<VertexPairConnection, Position>>> vertexConnections;
    private final Map<QueryVariable, List<Pair<VertexPairConnection, Position>>> commonVertexConnections;
    private final Map<QueryVariable, List<QueryExpression>> vertexConstraints;
    private final Set<QueryVariable> varsWithProperties;
    private final Map<QueryPath, PathFilters> pathConstraints;
    private final Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations;
    public final QueryTranslator.SubqueryInfo subqueryInfo;

    public TranslationInfo(List<ExpAsVar> subSelectElems, Set<VertexPairConnection> connections, Set<QueryExpression> constraints, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations, QueryContext ctx, QueryTranslator.SubqueryInfo subqueryInfo) {
        this.pathAggregations = pathAggregations;
        this.subqueryInfo = subqueryInfo;
        this.vertexConnections = new HashMap<QueryVariable, List<Pair<VertexPairConnection, Position>>>();
        this.commonVertexConnections = new HashMap<QueryVariable, List<Pair<VertexPairConnection, Position>>>();
        this.vertexConstraints = new HashMap<QueryVariable, List<QueryExpression>>();
        this.pathConstraints = new HashMap<QueryPath, PathFilters>();
        connections.forEach(connection -> {
            Pair<VertexPairConnection, Position> src = this.addVertexConnection(connection.getSrc(), (VertexPairConnection)connection, Position.SRC);
            Pair<VertexPairConnection, Position> dst = this.addVertexConnection(connection.getDst(), (VertexPairConnection)connection, Position.DST);
            if (connection.getVariableType() == QueryVariable.VariableType.PATH) {
                QueryPath queryPath = (QueryPath)connection;
                this.pathConstraints.put(queryPath, new PathFilters(queryPath, src, dst));
            }
        });
        subqueryInfo.parentConnections.forEach(connection -> {
            Pair<VertexPairConnection, Position> src = this.addParentVertexConnection(connection.getSrc(), (VertexPairConnection)connection, Position.SRC);
            Pair<VertexPairConnection, Position> dst = this.addParentVertexConnection(connection.getDst(), (VertexPairConnection)connection, Position.DST);
            if (connection.getVariableType() == QueryVariable.VariableType.PATH && src != null && dst != null) {
                QueryPath queryPath = (QueryPath)connection;
                this.pathConstraints.put(queryPath, new PathFilters(queryPath, src, dst));
            }
        });
        for (QueryVariable vertex : this.vertexConnections.keySet()) {
            if (this.vertexConstraints.containsKey(vertex)) continue;
            this.vertexConstraints.put(vertex, new ArrayList());
        }
        block1: for (QueryExpression constraint : constraints) {
            Set variables = PgqlUtils.getVariables((QueryExpression)constraint);
            for (QueryVariable vertex : this.vertexConnections.keySet()) {
                if (!variables.stream().allMatch(variable -> variable.equals((Object)vertex))) continue;
                this.addVertexConstraint((QueryVertex)vertex, constraint);
                continue block1;
            }
        }
        for (QueryPath qp : this.pathConstraints.keySet()) {
            PathTranslator.pushFilters(qp, this.pathConstraints.get(qp), this.vertexConnections, this.vertexConstraints, pathAggregations, ctx);
        }
        this.varsWithProperties = new HashSet<QueryVariable>();
        AbstractQueryExpressionVisitor visitor = new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.PropertyAccess propAccess) {
                TranslationInfo.this.varsWithProperties.add(ExpressionTranslator.getQueryVariable(propAccess.getVariable()));
            }
        };
        subSelectElems.forEach(expAsVar -> expAsVar.getExp().accept((QueryExpressionVisitor)visitor));
        constraints.forEach(c -> c.accept((QueryExpressionVisitor)visitor));
    }

    public Map<QueryVariable, List<Pair<VertexPairConnection, Position>>> getVertexConnections() {
        return this.vertexConnections;
    }

    public List<Pair<VertexPairConnection, Position>> getCommonVertexConnections(QueryVariable vertex) {
        List<Pair<VertexPairConnection, Position>> connections = this.commonVertexConnections.get(vertex);
        return connections == null ? Collections.emptyList() : connections;
    }

    public PathFilters getPathFilters(QueryPath queryPath) {
        return this.pathConstraints.get(queryPath);
    }

    public Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> getPathAggregations() {
        return this.pathAggregations;
    }

    public boolean needVertexConnectionJoin(QueryVariable vertex) {
        if (this.varsWithProperties.contains(vertex)) {
            return true;
        }
        Pair<VertexPairConnection, Position> pair = this.getEdgeConnection(vertex);
        if (pair == null) {
            return true;
        }
        return this.isParentVertex(vertex.getName()) && !this.commonVertexConnections.containsKey(vertex);
    }

    public boolean needParentLabelJoin(QueryVariable vertex) {
        if (this.isForParentWhere()) {
            return false;
        }
        return this.isParentVertex(vertex.getName());
    }

    private Pair<VertexPairConnection, Position> addVertexConnection(QueryVertex vertex, VertexPairConnection connection, Position position) {
        if (!this.vertexConnections.containsKey(vertex)) {
            this.vertexConnections.put((QueryVariable)vertex, new ArrayList());
        }
        Pair<VertexPairConnection, Position> pair = new Pair<VertexPairConnection, Position>(connection, position);
        this.vertexConnections.get(vertex).add(pair);
        return pair;
    }

    private Pair<VertexPairConnection, Position> addParentVertexConnection(QueryVertex vertex, VertexPairConnection connection, Position position) {
        Pair<VertexPairConnection, Position> pair = null;
        if (this.vertexConnections.containsKey(vertex)) {
            if (!this.commonVertexConnections.containsKey(vertex)) {
                this.commonVertexConnections.put((QueryVariable)vertex, new ArrayList());
            }
            pair = new Pair<VertexPairConnection, Position>(connection, position);
            this.commonVertexConnections.get(vertex).add(pair);
        }
        return pair;
    }

    private void addVertexConstraint(QueryVertex vertex, QueryExpression exp) {
        this.vertexConstraints.get(vertex).add(exp);
    }

    public Pair<VertexPairConnection, Position> getEdgeConnection(QueryVariable vertex) {
        if (this.vertexConnections.containsKey(vertex)) {
            for (Pair<VertexPairConnection, Position> connection : this.vertexConnections.get(vertex)) {
                if (((VertexPairConnection)connection.first).getVariableType() != QueryVariable.VariableType.EDGE) continue;
                return connection;
            }
        }
        return null;
    }

    public boolean isNotCommonVariableInSubquery(String variable) {
        return this.subqueryInfo.parentVariables.size() == 0 || !this.isParentVariable(variable);
    }

    public boolean isParentVariable(String variable) {
        return this.subqueryInfo.parentVariables.containsKey(variable);
    }

    public boolean isParentVertex(String vertex) {
        if (this.subqueryInfo.forParentWhere || this.subqueryInfo.parentGbVariables == null) {
            return this.subqueryInfo.parentVariables.containsKey(vertex);
        }
        return this.subqueryInfo.parentGbVariables.containsKey(vertex) || this.subqueryInfo.parentVariables.containsKey(vertex) && this.isInsideAggregate();
    }

    public boolean isForParentWhere() {
        return this.subqueryInfo.forParentWhere;
    }

    public boolean isInsideAggregate() {
        return this.subqueryInfo.insideAggregate;
    }

    public boolean canSplitId(String variable) {
        if (this.subqueryInfo.parentVariables.containsKey(variable)) {
            return (Boolean)this.subqueryInfo.parentVariables.get((Object)variable).first;
        }
        return false;
    }

    public static class PathFilters {
        Filter srcFilter;
        Filter dstFilter;

        public PathFilters(QueryPath queryPath, Pair<VertexPairConnection, Position> src, Pair<VertexPairConnection, Position> dst) {
            this.srcFilter = new Filter(queryPath.getSrc(), src);
            this.dstFilter = new Filter(queryPath.getDst(), dst);
        }

        public void reverseFilter() {
            Filter aux = this.dstFilter;
            this.dstFilter = this.srcFilter;
            this.srcFilter = aux;
            this.srcFilter.connection.second = Position.SRC;
            this.dstFilter.connection.second = Position.DST;
        }

        public static class Filter {
            private int pushedConstraints = 0;
            QueryVertex vertex;
            Pair<VertexPairConnection, Position> connection;
            Set<QueryVertex> vertices;
            Set<QueryExpression> constraints;
            Set<VertexPairConnection> connections;

            public Filter(QueryVertex vertex, VertexPairConnection connection) {
                this(vertex, new Pair<VertexPairConnection, Object>(connection, null));
            }

            public Filter(QueryVertex vertex, Pair<VertexPairConnection, Position> connection) {
                this.vertex = vertex;
                this.connection = connection;
                this.vertices = new HashSet<QueryVertex>();
                this.vertices.add(vertex);
                this.constraints = new HashSet<QueryExpression>();
                this.connections = new HashSet<VertexPairConnection>();
            }

            public void emptyFilter() {
                this.vertices = new HashSet<QueryVertex>();
                this.constraints = new HashSet<QueryExpression>();
                this.connections = new HashSet<VertexPairConnection>();
            }

            public void pushFilter(Filter filter) {
                this.vertices.addAll(filter.vertices);
                this.connections.addAll(filter.connections);
                this.constraints.addAll(filter.constraints);
                ++this.pushedConstraints;
            }

            public int filterWeight() {
                return this.pushedConstraints;
            }

            public void removeConnections(Map<QueryVariable, List<QueryExpression>> vertexConstraints) {
                this.emptyFilter();
                this.vertices.add(this.vertex);
                this.constraints.addAll((Collection<QueryExpression>)vertexConstraints.get(this.vertex));
            }
        }
    }

    public static enum Position {
        SRC,
        DST;

    }
}

