/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.time.OffsetDateTime;
import oracle.pg.rdbms.pgql.pgview.metadata.Cache;
import oracle.pg.rdbms.pgql.pgview.metadata.CacheMap;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.util.Pair;

public class PgViewMetadataCache
extends CacheMap<UserPgViewMetadataCache, MetadataConnector> {
    public Pair<MetadataConnector, OffsetDateTime> getGraphMetadata(Connection conn, String graphSchema, String graphName) {
        UserPgViewMetadataCache userCache = (UserPgViewMetadataCache)this.getUserCache(conn);
        return userCache.get(conn, graphSchema, graphName);
    }

    public void deleteGraphMetadata(Connection conn, String graphSchema, String graphName) {
        for (Cache.CacheKey key : this.userCaches.keySet()) {
            if (!this.getURL(key).equals(PgViewMetadataCache.getConnectionURL(conn))) continue;
            ((UserPgViewMetadataCache)this.userCaches.get(key)).removeEntry(graphSchema, graphName);
        }
    }

    @Override
    protected UserPgViewMetadataCache buildUserCache() {
        return new UserPgViewMetadataCache();
    }

    static class UserPgViewMetadataCache
    extends Cache<MetadataConnector> {
        UserPgViewMetadataCache() {
        }

        @Override
        Pair<MetadataConnector, OffsetDateTime> buildValue(Connection conn, String ... valueParameters) {
            String graphSchema = valueParameters[0];
            String graphName = valueParameters[1];
            return new Pair<MetadataConnector, OffsetDateTime>(new MetadataConnector(conn, graphSchema, graphName), OffsetDateTime.now());
        }
    }
}

