/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.PgqlToSqlException;

public class PgSqlMetaDataConnector {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsPgSql(Connection conn, String schemaName, String graphName) {
        String queryPgSql = "SELECT count(*) FROM SYS.ALL_PROPERTY_GRAPHS WHERE graph_name = ? AND owner = ?";
        try (PreparedStatement ps = conn.prepareStatement(queryPgSql);){
            ps.setString(1, graphName);
            ps.setString(2, schemaName);
            ResultSet rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() != 942) throw new PgqlToSqlException(ex);
            return false;
        }
    }
}

