/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.pg.rdbms.pgql.ValuePair;

public class SqlQuery {
    public static final String VAR_PROP_SEPARATOR = "$";
    public static final String COL_MODIFY_IDX_SEPARATOR = "_";
    private List<String> hintElems = new ArrayList<String>();
    private Map<String, String> withClause = new HashMap<String, String>();
    private List<ValuePair> selectElems = new ArrayList<ValuePair>();
    private List<List<ValuePair>> modifySelectElemsList = new ArrayList<List<ValuePair>>();
    private List<ValuePair> fromElems = new ArrayList<ValuePair>();
    private Map<Integer, List<ValuePair>> modifyFromElemsMap = new HashMap<Integer, List<ValuePair>>();
    private List<String> whereElems = new ArrayList<String>();
    private Map<Integer, List<String>> modifyWhereElemsMap = new HashMap<Integer, List<String>>();
    private List<String> groupElems = new ArrayList<String>();
    private List<String> havingElems = new ArrayList<String>();
    private List<String> orderElems = new ArrayList<String>();
    private String limit = "-1";
    private String offset = "-1";
    private boolean distinct = false;
    private String matchTableName = null;
    private Unpivot unpivot = null;

    public void clear() {
        this.hintElems.clear();
        this.withClause.clear();
        this.selectElems.clear();
        this.modifySelectElemsList.clear();
        this.fromElems.clear();
        this.modifyFromElemsMap.clear();
        this.whereElems.clear();
        this.modifyWhereElemsMap.clear();
        this.groupElems.clear();
        this.havingElems.clear();
        this.orderElems.clear();
        this.limit = "-1";
        this.offset = "-1";
        this.distinct = false;
        this.matchTableName = null;
        this.unpivot = null;
    }

    public void addHintElem(String h) {
        this.hintElems.add(h);
    }

    public void addWithClause(ValuePair vp) {
        this.withClause.put(vp.v2, vp.v1);
    }

    public void addModifySqlQueryElem(boolean addFromMatchQuery) {
        ArrayList<ValuePair> selectElems = new ArrayList<ValuePair>();
        this.modifySelectElemsList.add(selectElems);
        int idx = this.modifySelectElemsList.size() - 1;
        if (addFromMatchQuery) {
            selectElems.add(new ValuePair("MATCH_QUERY.ROW_ID", "ROW_ID"));
            this.putModifyFromElem(idx, new ValuePair(this.matchTableName, "MATCH_QUERY"));
        }
    }

    public void addSelectElem(ValuePair vp) {
        this.selectElems.add(vp);
    }

    public void addModifySelectElem(ValuePair vp) {
        this.modifySelectElemsList.get(this.modifySelectElemsList.size() - 1).add(vp);
    }

    public void addMatchModifySelectElem(ValuePair vp) {
        int modifyIdx = this.modifySelectElemsList.size() - 1;
        ValuePair matchVP = new ValuePair(vp.v1, vp.v2.substring(0, vp.v2.length() - 1) + COL_MODIFY_IDX_SEPARATOR + modifyIdx + "\"");
        this.addSelectElem(matchVP);
        ValuePair modifyVP = new ValuePair("MATCH_QUERY." + matchVP.v2, vp.v2);
        this.addModifySelectElem(modifyVP);
    }

    public String[] buildMatchTranslation(boolean useExtdSize) {
        if (this.matchTableName != null) {
            return new String[]{this.matchTableName, this.buildMatchDescription(useExtdSize).toString(), "SELECT ROWNUM, q.* FROM(" + this.buildSQLString() + ")q"};
        }
        return null;
    }

    private StringBuffer buildMatchDescription(boolean useExtdSize) {
        StringBuffer sqlBuff = new StringBuffer("(");
        sqlBuff.append("ROW_ID  NUMBER");
        for (int i = 0; i < this.selectElems.size(); ++i) {
            String colType;
            sqlBuff.append(",\n");
            ValuePair vp = this.selectElems.get(i);
            switch (vp.v2.substring(vp.v2.lastIndexOf(VAR_PROP_SEPARATOR) + 1, vp.v2.lastIndexOf(COL_MODIFY_IDX_SEPARATOR))) {
                case "IT": {
                    colType = "NCHAR(1)";
                    break;
                }
                case "V": {
                    colType = "NVARCHAR2(" + (useExtdSize ? "15000" : "2000") + ")";
                    break;
                }
                case "VT": {
                    colType = "TIMESTAMP(6) WITH TIME ZONE";
                    break;
                }
                default: {
                    colType = "NUMBER";
                }
            }
            sqlBuff.append(vp.v2).append(" ").append(colType);
        }
        sqlBuff.append(")");
        return sqlBuff;
    }

    public void addFromElem(ValuePair vp) {
        this.fromElems.add(vp);
    }

    public void putModifyFromElem(Integer i, ValuePair vp) {
        List<Object> l;
        if (this.modifyFromElemsMap.containsKey(i)) {
            l = this.modifyFromElemsMap.get(i);
        } else {
            l = new ArrayList();
            this.modifyFromElemsMap.put(i, l);
        }
        l.add(vp);
    }

    public void addWhereElem(String s) {
        this.whereElems.add(s);
    }

    public void putModifyWhereElem(Integer i, String s) {
        List<Object> l;
        if (this.modifyWhereElemsMap.containsKey(i)) {
            l = this.modifyWhereElemsMap.get(i);
        } else {
            l = new ArrayList();
            this.modifyWhereElemsMap.put(i, l);
        }
        l.add(s);
    }

    public void moveMatchElemsToModify() {
        for (int i = 0; i < this.modifySelectElemsList.size(); ++i) {
            for (ValuePair vp : this.fromElems) {
                this.putModifyFromElem(i, vp);
            }
            for (String s : this.whereElems) {
                this.putModifyWhereElem(i, s);
            }
        }
        this.fromElems.clear();
        this.whereElems.clear();
    }

    public void addGroupElem(String s) {
        this.groupElems.add(s);
    }

    public void addHavingElem(String s) {
        this.havingElems.add(s);
    }

    public void addOrderElem(String s) {
        this.orderElems.add(s);
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setMatchTableName(String matchTableName) {
        this.matchTableName = matchTableName;
    }

    public void addUnpivot(String selectColumns, String forColumn, String unpivotColumns) {
        this.unpivot = new Unpivot(selectColumns, forColumn, unpivotColumns);
    }

    public void addUnpivotList() {
        this.unpivot.addUnpivotList();
    }

    public void addUnpivotElem(String elem) {
        this.unpivot.addUnpivotElem(elem);
    }

    public String toString() {
        return "\nhintElems:\n" + this.hintElems.toString() + "\nwithClause:\n" + this.withClause.toString() + "\nselectElems:\n" + this.selectElems.toString() + "\nmodifySelectElemsList:\n" + this.modifySelectElemsList.toString() + "\nfromElems:\n" + this.fromElems.toString() + "\nmodifyFromElemsMap:\n" + this.modifyFromElemsMap.toString() + "\nwhereElems:\n" + this.whereElems.toString() + "\nmodifyWhereElemsMap:\n" + this.modifyWhereElemsMap.toString() + "\ngroupElems:\n" + this.groupElems.toString() + "\nhavingElems:\n" + this.havingElems.toString() + "\norderElems:\n" + this.orderElems.toString() + "\nlimit: " + this.limit + "\noffset: " + this.offset + "\ndistinct: " + this.distinct + "\nmatchTableName: " + this.matchTableName;
    }

    public StringBuffer buildSQLString() {
        return this.buildSQLString(this.selectElems, this.fromElems, this.whereElems, true, true);
    }

    public StringBuffer buildSQLModifyString(int idx) {
        return this.buildSQLString(this.modifySelectElemsList.get(idx), this.modifyFromElemsMap.get(idx), this.modifyWhereElemsMap.get(idx), this.matchTableName == null, this.matchTableName == null);
    }

    public StringBuffer buildSQLString(List<ValuePair> selectElems, List<ValuePair> fromElems, List<String> whereElems, boolean addGroupBy, boolean addOrderByAndLimit) {
        ValuePair vp;
        int i;
        StringBuffer sqlBuff = new StringBuffer("");
        if (this.withClause.size() > 0) {
            sqlBuff.append("WITH ");
            i = 0;
            for (String withAlias : this.withClause.keySet()) {
                if (i > 0) {
                    sqlBuff.append(",\n");
                }
                sqlBuff.append(withAlias).append(" AS ").append(this.withClause.get(withAlias));
                ++i;
            }
            sqlBuff.append("\n");
        }
        sqlBuff.append("SELECT ");
        if (this.hintElems.size() > 0) {
            sqlBuff.append("/*+ ");
            for (i = 0; i < this.hintElems.size(); ++i) {
                sqlBuff.append(this.hintElems.get(i)).append(" ");
            }
            sqlBuff.append("*/ ");
        }
        if (this.distinct) {
            sqlBuff.append("DISTINCT ");
        }
        if (selectElems.size() > 0) {
            for (i = 0; i < selectElems.size(); ++i) {
                if (i > 0) {
                    sqlBuff.append(",\n");
                }
                vp = selectElems.get(i);
                sqlBuff.append(vp.v1 + " AS " + vp.v2);
            }
        } else {
            sqlBuff.append("NULL as \"NULL\"");
        }
        sqlBuff.append("\nFROM ");
        if (fromElems != null && fromElems.size() > 0) {
            for (i = 0; i < fromElems.size(); ++i) {
                if (i > 0) {
                    sqlBuff.append(",\n");
                }
                vp = fromElems.get(i);
                sqlBuff.append(vp.v1 + " " + vp.v2);
            }
        } else {
            sqlBuff.append("SYS.DUAL");
        }
        if (whereElems != null && whereElems.size() > 0) {
            sqlBuff.append("\nWHERE ");
            for (i = 0; i < whereElems.size(); ++i) {
                if (i > 0) {
                    sqlBuff.append(" AND\n");
                }
                sqlBuff.append(whereElems.get(i));
            }
        }
        if (addGroupBy && this.groupElems.size() > 0) {
            sqlBuff.append("\nGROUP BY ");
            for (i = 0; i < this.groupElems.size(); ++i) {
                if (i > 0) {
                    sqlBuff.append(",\n");
                }
                sqlBuff.append(this.groupElems.get(i));
            }
        }
        if (this.havingElems.size() > 0) {
            sqlBuff.append("\nHAVING ");
            for (i = 0; i < this.havingElems.size(); ++i) {
                if (i > 0) {
                    sqlBuff.append(",\n");
                }
                sqlBuff.append(this.havingElems.get(i));
            }
        }
        if (addOrderByAndLimit) {
            if (this.orderElems.size() > 0) {
                sqlBuff.append("\nORDER BY ");
                for (i = 0; i < this.orderElems.size(); ++i) {
                    if (i > 0) {
                        sqlBuff.append(",\n");
                    }
                    sqlBuff.append(this.orderElems.get(i));
                }
            }
            if (!this.limit.equals("-1")) {
                String finalLimit = this.limit;
                if (!this.offset.equals("-1")) {
                    finalLimit = "(" + this.limit + " + " + this.offset + ")";
                }
                sqlBuff.insert(0, "SELECT * FROM(").append(")\nWHERE ROWNUM <= ").append(finalLimit);
            }
            if (!this.offset.equals("-1")) {
                StringBuffer selClause = new StringBuffer("SELECT ");
                for (int i2 = 0; i2 < selectElems.size(); ++i2) {
                    if (i2 > 0) {
                        selClause.append(", ");
                    }
                    ValuePair vp2 = selectElems.get(i2);
                    selClause.append(vp2.v2);
                }
                selClause.append(" FROM\n(SELECT R.*, ROWNUM AS PG$ROWNUM FROM(");
                sqlBuff.insert(0, selClause).append(")R )\nWHERE PG$ROWNUM > ").append(this.offset);
            }
        }
        return sqlBuff;
    }

    public StringBuffer buildQueryUnpivot() {
        StringBuffer sqlBuff = new StringBuffer("SELECT DISTINCT ").append(this.unpivot.selectColumns).append(this.unpivot.unpivotColumns).append("\nFROM(").append(this.buildSQLString()).append(")").append(this.unpivot.buildSQLString());
        return sqlBuff;
    }

    private class Unpivot {
        public String selectColumns;
        public String forColumn;
        public String unpivotColumns;
        private List<List<String>> inElems;
        private List<String> currentInElem;

        public Unpivot(String selectColumns, String forColumn, String unpivotColumns) {
            this.selectColumns = selectColumns;
            this.forColumn = forColumn;
            this.unpivotColumns = unpivotColumns;
            this.inElems = new ArrayList<List<String>>();
        }

        public void addUnpivotList() {
            this.currentInElem = new ArrayList<String>();
            this.inElems.add(this.currentInElem);
        }

        public void addUnpivotElem(String elem) {
            this.currentInElem.add(elem);
        }

        public StringBuffer buildSQLString() {
            StringBuffer sqlBuff = new StringBuffer();
            if (this.inElems.size() > 0) {
                sqlBuff.append("\nUNPIVOT (").append("\n  (").append(this.unpivotColumns).append(")").append("\n  for ").append(((SqlQuery)SqlQuery.this).unpivot.forColumn).append("\n    IN (\n");
                for (int i = 0; i < this.inElems.size(); ++i) {
                    if (i > 0) {
                        sqlBuff.append(",\n");
                    }
                    sqlBuff.append("    (");
                    List<String> currentInElem = this.inElems.get(i);
                    for (int j = 0; j < currentInElem.size(); ++j) {
                        if (j > 0) {
                            sqlBuff.append(", ");
                        }
                        sqlBuff.append(currentInElem.get(j));
                    }
                    sqlBuff.append(") AS ").append(i);
                }
                sqlBuff.append(")\n  )");
            }
            return sqlBuff;
        }
    }
}

