/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.ExprTransVisitor;
import oracle.pg.rdbms.pgql.ExprTranslation;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNavigator {
    private static Logger ms_log = LoggerFactory.getLogger(ExprNavigator.class);
    private final Map<String, QueryExpression> exprAliasMap;
    private final BindValueInfo bvInfo;

    private ExprNavigator(Map<String, QueryExpression> exprAliasMap, BindValueInfo bvInfo) {
        this.exprAliasMap = exprAliasMap != null ? exprAliasMap : new HashMap<String, QueryExpression>();
        this.bvInfo = bvInfo;
    }

    public static ExprNavigator getExprNavigator(Map<String, QueryExpression> exprAliasMap, BindValueInfo bvInfo) {
        return new ExprNavigator(exprAliasMap, bvInfo);
    }

    protected ExprTranslation accept(QueryExpression qe, ExprTransVisitor v) throws PgqlToSqlException {
        return this.accept(qe, v, true, false);
    }

    protected ExprTranslation accept(QueryExpression qe, ExprTransVisitor v, boolean isRoot, boolean negated) throws PgqlToSqlException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Accepting: " + qe + " [" + qe.getClass().getName() + "] isRoot=[" + isRoot + "] negated=[" + negated + "]");
        }
        QueryExpression.ExpressionType exprType = qe.getExpType();
        switch (exprType) {
            case INTEGER: {
                return v.visit((QueryExpression.Constant.ConstInteger)qe, null, (String[][])null, isRoot, negated);
            }
            case DECIMAL: {
                return v.visit((QueryExpression.Constant.ConstDecimal)qe, null, (String[][])null, isRoot, negated);
            }
            case STRING: {
                return v.visit((QueryExpression.Constant.ConstString)qe, null, (String[][])null, isRoot, negated);
            }
            case BOOLEAN: {
                return v.visit((QueryExpression.Constant.ConstBoolean)qe, null, (String[][])null, isRoot, negated);
            }
            case DATE: {
                return v.visit((QueryExpression.Constant.ConstDate)qe, null, (String[][])null, isRoot, negated);
            }
            case TIME: {
                return v.visit((QueryExpression.Constant.ConstTime)qe, null, (String[][])null, isRoot, negated);
            }
            case TIMESTAMP: {
                return v.visit((QueryExpression.Constant.ConstTimestamp)qe, null, (String[][])null, isRoot, negated);
            }
            case TIME_WITH_TIMEZONE: {
                return v.visit((QueryExpression.Constant.ConstTimeWithTimezone)qe, null, (String[][])null, isRoot, negated);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return v.visit((QueryExpression.Constant.ConstTimestampWithTimezone)qe, null, (String[][])null, isRoot, negated);
            }
            case BIND_VARIABLE: {
                return v.visit((QueryExpression.BindVariable)qe, null, (String[][])null, isRoot, negated);
            }
            case VARREF: {
                QueryVariable qv = ((QueryExpression.VarRef)qe).getVariable();
                String varName = qv.getName();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nChecking VarRef:" + varName);
                }
                if (this.exprAliasMap.containsKey(varName) && qv.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                    QueryExpression mappedExpr = this.exprAliasMap.get(varName);
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("\nFound Mapped Expression:" + mappedExpr);
                    }
                    return this.accept(mappedExpr, v, isRoot, negated);
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nNo Mapped Expression: visiting var");
                }
                return v.visit((QueryExpression.VarRef)qe, null, (String[][])null, isRoot, negated);
            }
            case PROP_ACCESS: {
                QueryExpression.PropertyAccess pa = (QueryExpression.PropertyAccess)qe;
                QueryVariable qv = pa.getVariable();
                String varName = qv.getName();
                if (this.exprAliasMap.containsKey(varName) && qv.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                    QueryExpression mappedExpr = this.exprAliasMap.get(varName);
                    if (mappedExpr.getExpType() == QueryExpression.ExpressionType.VARREF) {
                        QueryExpression.PropertyAccess rawPropAccess = new QueryExpression.PropertyAccess(((QueryExpression.VarRef)mappedExpr).getVariable(), pa.getPropertyName());
                        return this.accept((QueryExpression)rawPropAccess, v, isRoot, negated);
                    }
                    throw new PgqlToSqlException("Unexpected element under QueryExpression.PropertyAccess");
                }
                return v.visit((QueryExpression.PropertyAccess)qe, null, (String[][])null, isRoot, negated);
            }
            case STAR: {
                return v.visit((QueryExpression.Star)qe, null, (String[][])null, isRoot, negated);
            }
            case SUB: 
            case ADD: 
            case MUL: 
            case DIV: 
            case MOD: 
            case AND: 
            case OR: 
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER: 
            case GREATER_EQUAL: 
            case LESS: 
            case LESS_EQUAL: {
                QueryExpression.BinaryExpression be = (QueryExpression.BinaryExpression)qe;
                String[][] childSql = new String[2][];
                int[] childTypeFams = new int[2];
                ExprTranslation t1 = this.accept(be.getExp1(), v, false, negated);
                childSql[0] = t1.getSQL();
                childTypeFams[0] = t1.getTypeFam();
                ExprTranslation t2 = this.accept(be.getExp2(), v, false, negated);
                childSql[1] = t2.getSQL();
                childTypeFams[1] = t2.getTypeFam();
                if (exprType == QueryExpression.ExpressionType.SUB) {
                    return v.visit((QueryExpression.ArithmeticExpression.Sub)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.ADD) {
                    return v.visit((QueryExpression.ArithmeticExpression.Add)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.MUL) {
                    return v.visit((QueryExpression.ArithmeticExpression.Mul)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.DIV) {
                    return v.visit((QueryExpression.ArithmeticExpression.Div)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.MOD) {
                    return v.visit((QueryExpression.ArithmeticExpression.Mod)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.AND) {
                    return v.visit((QueryExpression.LogicalExpression.And)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.OR) {
                    return v.visit((QueryExpression.LogicalExpression.Or)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.EQUAL) {
                    return v.visit((QueryExpression.RelationalExpression.Equal)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.NOT_EQUAL) {
                    return v.visit((QueryExpression.RelationalExpression.NotEqual)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.GREATER) {
                    return v.visit((QueryExpression.RelationalExpression.Greater)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.GREATER_EQUAL) {
                    return v.visit((QueryExpression.RelationalExpression.GreaterEqual)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.LESS) {
                    return v.visit((QueryExpression.RelationalExpression.Less)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.LESS_EQUAL) {
                    return v.visit((QueryExpression.RelationalExpression.LessEqual)qe, childTypeFams, childSql, isRoot, negated);
                }
                throw new PgqlToSqlException("Unexpected type:" + exprType);
            }
            case SIMPLE_CASE: {
                QueryExpression.SimpleCase sc = (QueryExpression.SimpleCase)qe;
                return this.accept((QueryExpression)sc.getIfElseRepresentation(), v, isRoot, negated);
            }
            case IF_ELSE: {
                String[][] childSql = new String[3][];
                int[] childTypeFams = new int[3];
                QueryExpression.IfElse ie = (QueryExpression.IfElse)qe;
                ExprTranslation t1 = this.accept(ie.getExp1(), v, false, negated);
                childSql[0] = t1.getSQL();
                childTypeFams[0] = t1.getTypeFam();
                ExprTranslation t2 = this.accept(ie.getExp2(), v, false, negated);
                childSql[1] = t2.getSQL();
                childTypeFams[1] = t2.getTypeFam();
                ExprTranslation t3 = this.accept(ie.getExp3(), v, false, negated);
                childSql[2] = t3.getSQL();
                childTypeFams[2] = t3.getTypeFam();
                return v.visit(ie, childTypeFams, childSql, isRoot, negated);
            }
            case CAST: {
                String[][] childSql = new String[1][];
                int[] childTypeFams = new int[1];
                QueryExpression.Function.Cast c = (QueryExpression.Function.Cast)qe;
                ExprTranslation t1 = this.accept(c.getExp(), v, false, negated);
                childSql[0] = t1.getSQL();
                childTypeFams[0] = t1.getTypeFam();
                return v.visit(c, childTypeFams, childSql, isRoot, negated);
            }
            case EXISTS: {
                return v.visit((QueryExpression.Function.Exists)qe, null, (String[][])null, isRoot, negated);
            }
            case EXTRACT_EXPRESSION: {
                String[][] childSql = new String[1][];
                int[] childTypeFams = new int[1];
                QueryExpression.ExtractExpression e = (QueryExpression.ExtractExpression)qe;
                ExprTranslation t1 = this.accept(e.getExp(), v, false, negated);
                childSql[0] = t1.getSQL();
                childTypeFams[0] = t1.getTypeFam();
                return v.visit(e, childTypeFams, childSql, isRoot, negated);
            }
            case IS_NULL: {
                String[][] childSql = new String[1][];
                int[] childTypeFams = new int[1];
                QueryExpression.IsNull is = (QueryExpression.IsNull)qe;
                ExprTranslation t1 = this.accept(is.getExp(), v, false, negated);
                childSql[0] = t1.getSQL();
                childTypeFams[0] = t1.getTypeFam();
                return v.visit(is, childTypeFams, childSql, isRoot, negated);
            }
            case SCALAR_SUBQUERY: {
                return v.visit((QueryExpression.ScalarSubquery)qe, null, (String[][])null, isRoot, negated);
            }
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall fc = (QueryExpression.FunctionCall)qe;
                List exps = fc.getArgs();
                int numExps = exps.size();
                ExprTranslation[] tArray = new ExprTranslation[numExps];
                String[][] childSql = new String[numExps][];
                int[] childTypeFams = new int[numExps];
                for (int i = 0; i < numExps; ++i) {
                    tArray[i] = this.accept((QueryExpression)exps.get(i), v, false, negated);
                    childSql[i] = tArray[i].getSQL();
                    childTypeFams[i] = tArray[i].getTypeFam();
                }
                return v.visit(fc, childTypeFams, childSql, isRoot, negated);
            }
            case NOT: 
            case UMIN: 
            case AGGR_COUNT: 
            case AGGR_MIN: 
            case AGGR_MAX: 
            case AGGR_SUM: 
            case AGGR_AVG: {
                QueryExpression.UnaryExpression ue = (QueryExpression.UnaryExpression)qe;
                String[][] childSql = new String[1][];
                int[] childTypeFams = new int[1];
                boolean childNegated = exprType == QueryExpression.ExpressionType.NOT || negated;
                ExprTranslation t1 = this.accept(ue.getExp(), v, false, childNegated);
                childSql[0] = t1.getSQL();
                childTypeFams[0] = t1.getTypeFam();
                if (exprType == QueryExpression.ExpressionType.UMIN) {
                    return v.visit((QueryExpression.ArithmeticExpression.UMin)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.NOT) {
                    return v.visit((QueryExpression.LogicalExpression.Not)qe, childTypeFams, childSql, isRoot, true);
                }
                if (exprType == QueryExpression.ExpressionType.AGGR_COUNT) {
                    return v.visit((QueryExpression.Aggregation.AggrCount)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.AGGR_MIN) {
                    return v.visit((QueryExpression.Aggregation.AggrMin)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.AGGR_MAX) {
                    return v.visit((QueryExpression.Aggregation.AggrMax)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.AGGR_SUM) {
                    return v.visit((QueryExpression.Aggregation.AggrSum)qe, childTypeFams, childSql, isRoot, negated);
                }
                if (exprType == QueryExpression.ExpressionType.AGGR_AVG) {
                    return v.visit((QueryExpression.Aggregation.AggrAvg)qe, childTypeFams, childSql, isRoot, negated);
                }
                throw new PgqlToSqlException("Unexpected type:" + exprType);
            }
            case IN_EXPRESSION: {
                String[][] childSql = new String[1][];
                int[] childTypeFams = new int[1];
                QueryExpression.InPredicate in = (QueryExpression.InPredicate)qe;
                ExprTranslation t1 = this.accept(in.getExp(), v, false, negated);
                childSql[0] = t1.getSQL();
                childTypeFams[0] = t1.getTypeFam();
                return v.visit(in, childTypeFams, childSql, isRoot, negated);
            }
            case AGGR_ARRAY_AGG: 
            case AGGR_LISTAGG: 
            case CONCAT: 
            case SUBSTRING: {
                throw new PgqlToSqlException("Unsupported feature:" + exprType);
            }
            case ALL_PROPERTIES: {
                throw new PgqlToSqlException("Selecting all properties through " + qe + " is not supported for PG schema");
            }
        }
        return new ExprTranslation(new String[]{""}, 12);
    }
}

