/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal.adb;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import oracle.pg.rdbms.AdbGraphClientConfiguration;
import oracle.pg.rdbms.exception.GraphClientException;
import oracle.pg.rdbms.internal.AbstractHttpClient;
import oracle.pg.rdbms.internal.UriUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerClient
extends AbstractHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrokerClient.class);
    private static final String REQUEST_ID_PREFIX = "GraphClient-";
    private final AdbGraphClientConfiguration config;
    private final URI tokenUrl;

    public BrokerClient(AdbGraphClientConfiguration config, URI brokerBaseURI) {
        super(config.getHttpClient());
        this.config = config;
        this.tokenUrl = UriUtils.appendPath(brokerBaseURI, "public/v1/token");
    }

    public Map<String, Object> buildCreateTokenRequest(String username, String password) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("grant_type", "password");
        if (this.config.getTenancyOcid() != null && this.config.getTenant() != null) {
            log.warn("you provided both tenant() and tenantOcid() - will ignore deprecated tenant() and use use value of tenantOcid()");
        }
        if (this.config.getTenant() != null) {
            request.put("tenant_name", this.config.getTenant());
        }
        if (this.config.getTenancyOcid() != null) {
            request.put("tenant_name", this.config.getTenancyOcid());
        }
        if (this.config.getDatabaseOcid() != null && this.config.getCloudDatabaseName() != null) {
            log.warn("you provided both cloudDatabaseName() and databaseOcid() - will ignore deprecated cloudDatabaseName() and use value of databaseOcid()");
        }
        if (this.config.getCloudDatabaseName() != null) {
            request.put("cloud_database_name", this.config.getCloudDatabaseName());
        }
        if (this.config.getDatabaseOcid() != null) {
            request.put("cloud_database_name", this.config.getDatabaseOcid());
        }
        request.put("database_name", this.config.getDatabase());
        request.put("username", username);
        request.put("password", password);
        return request;
    }

    public String createToken(String username, String password) {
        Map<String, Object> request = this.buildCreateTokenRequest(username, password);
        return this.postJson(request);
    }

    public Map<String, Object> buildRefreshTokenRequest(String token) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("grant_type", "refresh_token");
        if (this.config.getTenant() != null) {
            request.put("tenant_name", this.config.getTenant());
        }
        if (this.config.getTenancyOcid() != null) {
            request.put("tenant_name", this.config.getTenancyOcid());
        }
        if (this.config.getDatabase() != null) {
            request.put("database_name", this.config.getDatabase());
        }
        if (this.config.getCloudDatabaseName() != null) {
            request.put("cloud_database_name", this.config.getCloudDatabaseName());
        }
        if (this.config.getDatabaseOcid() != null) {
            request.put("cloud_database_name", this.config.getDatabaseOcid());
        }
        request.put("token", token);
        return request;
    }

    public String refreshToken(String token) {
        Map<String, Object> request = this.buildRefreshTokenRequest(token);
        return this.postJson(request);
    }

    private String postJson(Map<String, Object> request) {
        String requestId = BrokerClient.generateRequestId();
        AbstractHttpClient.JsonResponse response = this.postJson(this.tokenUrl, request, requestId, null);
        Map<String, Object> body = response.getBody();
        if (response.getStatusCode() == 200) {
            String token = (String)body.get("access_token");
            if (StringUtils.isEmpty((CharSequence)token)) {
                throw new GraphClientException("failed to obtain authentication token", requestId);
            }
            return token;
        }
        throw new GraphClientException("authentication failure: code = " + body.get("code") + ", error = " + body.get("error") + ", message = " + body.get("message"), requestId);
    }

    private static String generateRequestId() {
        return REQUEST_ID_PREFIX + RandomStringUtils.randomAlphanumeric((int)(32 - REQUEST_ID_PREFIX.length()));
    }
}

