/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import oracle.pg.rdbms.exception.GraphClientException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClient.class);
    protected static final String ACCESS_TOKEN = "access_token";
    protected static final String OCI_REQUEST_ID_HEADER = "opc-request-id";
    protected static final String ADB_REQUEST_ID_HEADER = "Request-Id";
    protected final HttpClient httpClient;
    protected final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpClientContext context;

    protected AbstractHttpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.context = HttpClientContext.create();
        this.context.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
    }

    protected JsonResponse postJson(URI url, Map<String, Object> body) {
        return this.postJson(url, body, null, null);
    }

    protected JsonResponse postJson(URI url, Map<String, Object> body, String requestId, Map<String, String> additionalHeaders) {
        log.info("POST {}", (Object)url);
        return this.requestJson((HttpUriRequestBase)new HttpPost(url), body, requestId, additionalHeaders);
    }

    protected JsonResponse putJson(URI url, Map<String, Object> body) {
        return this.putJson(url, body, null, null);
    }

    protected JsonResponse putJson(URI url, Map<String, Object> body, String requestId, Map<String, String> additionalHeaders) {
        log.info("PUT {}", (Object)url);
        return this.requestJson((HttpUriRequestBase)new HttpPut(url), body, requestId, additionalHeaders);
    }

    protected JsonResponse getJson(URI url, String requestId, Map<String, String> additionalHeaders) {
        return this.requestJson((HttpUriRequestBase)new HttpGet(url), requestId, additionalHeaders);
    }

    protected JsonResponse deleteJson(URI url, String requestId, Map<String, String> additionalHeaders) {
        return this.requestJson((HttpUriRequestBase)new HttpDelete(url), requestId, additionalHeaders);
    }

    private JsonResponse requestJson(HttpUriRequestBase request, Map<String, Object> body, String requestId, Map<String, String> additionalHeaders) {
        try {
            if (body != null) {
                StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString(body));
                request.setEntity((HttpEntity)entity);
            }
            return this.requestJson(request, requestId, additionalHeaders);
        }
        catch (IOException e) {
            throw new GraphClientException("could not serialize JSON", requestId, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JsonResponse requestJson(HttpUriRequestBase request, String requestId, Map<String, String> additionalHeaders) {
        URI url = this.getRequestUri(request, requestId);
        try {
            request.setHeader("Accept", (Object)ContentType.APPLICATION_JSON.toString());
            request.setHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.toString());
            if (requestId != null) {
                request.setHeader(ADB_REQUEST_ID_HEADER, (Object)requestId);
            }
            if (additionalHeaders != null) {
                additionalHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequestBase)request).setHeader(arg_0, arg_1));
            }
            ClassicHttpResponse response = (ClassicHttpResponse)this.httpClient.execute((ClassicHttpRequest)request, (HttpContext)this.context);
            int statusCode = response.getCode();
            log.debug("statusCode = {}", (Object)statusCode);
            String responseBody = "";
            try {
                if (requestId == null) {
                    requestId = AbstractHttpClient.getRequestIdFromResponse((HttpResponse)response);
                }
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                log.debug("response (raw) = {}", (Object)responseBody);
                if (!response.getEntity().getContentType().contains(ContentType.APPLICATION_JSON.getMimeType())) {
                    String msg = MessageFormat.format("Could not complete request successfully, please contact the server admin. HTTP status code {0}: {1}", statusCode, responseBody);
                    throw new GraphClientException(msg, requestId);
                }
                if (statusCode < 200 || statusCode >= 300) {
                    String msg = MessageFormat.format("Could not complete request successfully. HTTP status code {0}: {1}", statusCode, responseBody);
                    throw new GraphClientException(msg, requestId);
                }
                Map json = (Map)this.objectMapper.readValue(responseBody, Map.class);
                log.debug("response (parsed) = {}", (Object)json);
                JsonResponse jsonResponse = new JsonResponse(statusCode, requestId, json, this.context.getCookieStore());
                return jsonResponse;
            }
            catch (JsonParseException | ParseException e) {
                if (url.getScheme() != null && url.getScheme().equals("http")) {
                    throw new GraphClientException("Could not parse server response. Try to use HTTPS instead of HTTP.", requestId, e);
                }
                String msg = MessageFormat.format("Could not parse server response. HTTP status code {0}: {1}", statusCode, responseBody);
                throw new GraphClientException(msg, requestId, e);
            }
            finally {
                AbstractHttpClient.close((HttpResponse)response);
            }
        }
        catch (IOException e) {
            String message = "could not execute request " + request.getMethod() + " " + url;
            throw new GraphClientException(message, requestId, e);
        }
    }

    private URI getRequestUri(HttpUriRequestBase request, String requestId) {
        try {
            return request.getUri();
        }
        catch (URISyntaxException e) {
            String message = "could not obtain URI from request";
            throw new GraphClientException(message, requestId, e);
        }
    }

    protected static void close(HttpResponse response) throws IOException {
        if (response instanceof CloseableHttpResponse) {
            ((CloseableHttpResponse)response).close();
        }
    }

    protected static String getRequestIdFromResponse(HttpResponse response) {
        Header header = response.getFirstHeader(OCI_REQUEST_ID_HEADER);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    protected static class JsonResponse {
        private final int statusCode;
        private final String requestId;
        private final Map<String, Object> body;
        private final CookieStore cookies;

        @Generated
        public JsonResponse(int statusCode, String requestId, Map<String, Object> body, CookieStore cookies) {
            this.statusCode = statusCode;
            this.requestId = requestId;
            this.body = body;
            this.cookies = cookies;
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public Map<String, Object> getBody() {
            return this.body;
        }

        @Generated
        public CookieStore getCookies() {
            return this.cookies;
        }
    }
}

