/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal.adb;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import oracle.pg.rdbms.AdbGraphClientConfiguration;
import oracle.pg.rdbms.exception.GraphClientException;
import oracle.pg.rdbms.internal.AbstractHttpClient;
import oracle.pg.rdbms.internal.UriUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class BrokerClient
extends AbstractHttpClient {
    private static final String REQUEST_ID_PREFIX = "GraphClient-";
    private final AdbGraphClientConfiguration config;
    private final URI tokenUrl;

    public BrokerClient(AdbGraphClientConfiguration config, URI brokerBaseURI) {
        super(config.getHttpClient());
        this.config = config;
        this.tokenUrl = UriUtils.appendPath(brokerBaseURI, "public/v1/token");
    }

    public String createToken(String username, String password) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("grant_type", "password");
        request.put("tenant_name", this.config.getTenant());
        request.put("database_name", this.config.getDatabase());
        request.put("username", username);
        request.put("password", password);
        return this.postJson(request);
    }

    public String refreshToken(String token) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("grant_type", "refresh_token");
        request.put("tenant_name", this.config.getTenant());
        request.put("database_name", this.config.getDatabase());
        request.put("token", token);
        return this.postJson(request);
    }

    private String postJson(Map<String, Object> request) {
        String requestId = BrokerClient.generateRequestId();
        AbstractHttpClient.JsonResponse response = this.postJson(this.tokenUrl, request, requestId, null);
        Map<String, Object> body = response.getBody();
        if (response.getStatusCode() == 200) {
            String token = (String)body.get("access_token");
            if (StringUtils.isEmpty((CharSequence)token)) {
                throw new GraphClientException("failed to obtain authentication token", requestId);
            }
            return token;
        }
        throw new GraphClientException("authentication failure: code = " + body.get("code") + ", error = " + body.get("error") + ", message = " + body.get("message"), requestId);
    }

    private static String generateRequestId() {
        return REQUEST_ID_PREFIX + RandomStringUtils.randomAlphanumeric((int)(32 - REQUEST_ID_PREFIX.length()));
    }
}

