/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import oracle.pg.rdbms.exception.GraphClientException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClient.class);
    protected static final String ACCESS_TOKEN = "access_token";
    protected static final String OCI_REQUEST_ID_HEADER = "opc-request-id";
    protected static final String ADB_REQUEST_ID_HEADER = "Request-Id";
    protected final HttpClient httpClient;
    protected final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpClientContext context;

    protected AbstractHttpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.context = HttpClientContext.create();
        this.context.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
    }

    protected JsonResponse postJson(URI url, Map<String, Object> body) {
        return this.postJson(url, body, null, null);
    }

    protected JsonResponse postJson(URI url, Map<String, Object> body, String requestId, Map<String, String> additionalHeaders) {
        log.info("POST {}", (Object)url);
        return this.requestJson((HttpEntityEnclosingRequestBase)new HttpPost(url), body, requestId, additionalHeaders);
    }

    protected JsonResponse putJson(URI url, Map<String, Object> body) {
        return this.putJson(url, body, null, null);
    }

    protected JsonResponse putJson(URI url, Map<String, Object> body, String requestId, Map<String, String> additionalHeaders) {
        log.info("PUT {}", (Object)url);
        return this.requestJson((HttpEntityEnclosingRequestBase)new HttpPut(url), body, requestId, additionalHeaders);
    }

    protected JsonResponse getJson(URI url, String requestId, Map<String, String> additionalHeaders) {
        return this.requestJson((HttpRequestBase)new HttpGet(url), requestId, additionalHeaders);
    }

    protected JsonResponse deleteJson(URI url, String requestId, Map<String, String> additionalHeaders) {
        return this.requestJson((HttpRequestBase)new HttpDelete(url), requestId, additionalHeaders);
    }

    private JsonResponse requestJson(HttpEntityEnclosingRequestBase request, Map<String, Object> body, String requestId, Map<String, String> additionalHeaders) {
        try {
            if (body != null) {
                StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString(body));
                request.setEntity((HttpEntity)entity);
            }
            return this.requestJson((HttpRequestBase)request, requestId, additionalHeaders);
        }
        catch (IOException e) {
            throw new GraphClientException("could not serialize JSON", requestId, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonResponse requestJson(HttpRequestBase request, String requestId, Map<String, String> additionalHeaders) {
        URI url = request.getURI();
        try {
            request.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            if (requestId != null) {
                request.setHeader(ADB_REQUEST_ID_HEADER, requestId);
            }
            if (additionalHeaders != null) {
                additionalHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).setHeader(arg_0, arg_1));
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)this.context);
            int statusCode = response.getStatusLine().getStatusCode();
            log.debug("statusCode = {}", (Object)statusCode);
            try {
                if (requestId == null) {
                    requestId = AbstractHttpClient.getRequestIdFromResponse(response);
                }
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                log.debug("response (raw) = {}", (Object)responseBody);
                Map json = (Map)this.objectMapper.readValue(responseBody, Map.class);
                log.debug("response (parsed) = {}", (Object)json);
                JsonResponse jsonResponse = new JsonResponse(statusCode, requestId, json, this.context.getCookieStore());
                return jsonResponse;
            }
            catch (JsonParseException e) {
                if (url.getScheme() == null) throw new GraphClientException("Could not parse server response.", requestId, e);
                if (!url.getScheme().equals("http")) throw new GraphClientException("Could not parse server response.", requestId, e);
                throw new GraphClientException("Could not parse server response. Try to use HTTPS instead of HTTP.", requestId, e);
            }
            finally {
                AbstractHttpClient.close(response);
            }
        }
        catch (IOException e) {
            String message = "could not execute request " + request.getMethod() + " " + url;
            throw new GraphClientException(message, requestId, e);
        }
    }

    protected static void close(HttpResponse response) throws IOException {
        if (response instanceof CloseableHttpResponse) {
            ((CloseableHttpResponse)response).close();
        }
    }

    protected static String getRequestIdFromResponse(HttpResponse response) {
        Header header = response.getFirstHeader(OCI_REQUEST_ID_HEADER);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    protected static class JsonResponse {
        private final int statusCode;
        private final String requestId;
        private final Map<String, Object> body;
        private final CookieStore cookies;

        @Generated
        public JsonResponse(int statusCode, String requestId, Map<String, Object> body, CookieStore cookies) {
            this.statusCode = statusCode;
            this.requestId = requestId;
            this.body = body;
            this.cookies = cookies;
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public Map<String, Object> getBody() {
            return this.body;
        }

        @Generated
        public CookieStore getCookies() {
            return this.cookies;
        }
    }
}

