/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.io.IOException;
import java.util.Objects;
import oracle.pg.rdbms.internal.onprem.GraphRealmClient;
import oracle.pg.rdbms.internal.onprem.GraphServerClient;
import oracle.pg.rdbms.internal.onprem.TokenResponse;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.common.util.StringUtils;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.realm.client.RealmClient;
import org.apache.http.client.HttpClient;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.HttpClients;

public class GraphServer {
    public static final int DEFAULT_TIME_BEFORE_EXPIRY = 1800;
    private static GraphServerClient CLIENT = null;

    private static GraphServerClient getClient() {
        if (CLIENT == null) {
            CLIENT = new GraphServerClient((HttpClient)HttpClients.createDefault());
        }
        return CLIENT;
    }

    private GraphServer() {
    }

    public static ServerInstance getEmbeddedInstance() {
        return Pgx.getInstance((String)Pgx.EMBEDDED_URL);
    }

    public static ServerInstance getInstance(ClientConfig clientConfig, String username, char[] password) throws IOException {
        return GraphServer.getInstance(clientConfig, username, password, 1800);
    }

    public static ServerInstance getInstance(ClientConfig clientConfig, String username, char[] password, int refreshTimeBeforeTokenExpiry) throws IOException {
        String baseUrl = clientConfig.getBaseUrl();
        if (StringUtils.isEmpty((String)baseUrl)) {
            throw new IllegalArgumentException("No base URL given");
        }
        TokenResponse response = GraphServer.generateToken(baseUrl, username, password);
        String token = response.getToken();
        Cookie stickyCookie = response.getCookie();
        GraphRealmClient realmClient = new GraphRealmClient(GraphServer.getClient(), baseUrl, token, refreshTimeBeforeTokenExpiry, stickyCookie);
        clientConfig.getValues().put(ClientConfig.Field.ACCESS_TOKEN, token);
        return Pgx.getInstance((ClientConfig)clientConfig, (RealmClient)realmClient);
    }

    public static ServerInstance getInstance(String baseUrl, String username, char[] password) throws IOException {
        return GraphServer.getInstance(baseUrl, username, password, 1800);
    }

    public static ServerInstance getInstance(String baseUrl, String username, char[] password, int refreshTimeBeforeTokenExpiry) throws IOException {
        TokenResponse response = GraphServer.generateToken(baseUrl, username, password);
        String token = response.getToken();
        Cookie stickyCookie = response.getCookie();
        GraphRealmClient realmClient = new GraphRealmClient(GraphServer.getClient(), baseUrl, token, refreshTimeBeforeTokenExpiry, stickyCookie);
        return Pgx.getInstance((String)baseUrl, (RealmClient)realmClient);
    }

    public static ServerInstance getInstance(String baseUrl, String kerberosTicketPath) throws IOException {
        return GraphServer.getInstance(baseUrl, kerberosTicketPath, 1800);
    }

    public static ServerInstance getInstance(String baseUrl, String kerberosTicketPath, int refreshTimeBeforeTokenExpiry) throws IOException {
        TokenResponse response = GraphServer.generateToken(baseUrl, kerberosTicketPath);
        String token = response.getToken();
        Cookie stickyCookie = response.getCookie();
        GraphRealmClient realmClient = new GraphRealmClient(GraphServer.getClient(), baseUrl, token, refreshTimeBeforeTokenExpiry, stickyCookie);
        return Pgx.getInstance((String)baseUrl, (RealmClient)realmClient);
    }

    public static ServerInstance reauthenticate(ServerInstance instance, String username, char[] password) throws IOException {
        TokenResponse response = GraphServer.generateToken(instance.getBaseUrl(), username, password);
        instance.setToken(response.getToken());
        return instance;
    }

    public static TokenResponse generateToken(String baseUrl, String username, char[] password) throws IOException {
        baseUrl = Objects.requireNonNull(baseUrl, "baseUrl must not be NULL");
        username = Objects.requireNonNull(username, "username must not be NULL");
        password = Objects.requireNonNull(password, "password must not be NULL");
        return GraphServer.getClient().createToken(baseUrl, username, new String(password));
    }

    public static TokenResponse generateToken(String baseUrl, String kerberosTicketPath) throws IOException {
        baseUrl = Objects.requireNonNull(baseUrl, "baseUrl must not be NULL");
        kerberosTicketPath = Objects.requireNonNull(kerberosTicketPath, "kerberosTicket must not be NULL");
        return GraphServer.getClient().createToken(baseUrl, kerberosTicketPath);
    }
}

