/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import java.util.List;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class EdgeTable
extends ElementTable {
    VertexTable sourceVertexTable;
    Key edgeSourceKey;
    Key sourceVertexKey;
    VertexTable destinationVertexTable;
    Key edgeDestinationKey;
    Key destinationVertexKey;

    public EdgeTable(SchemaQualifiedName tableName, VertexTable sourceVertexTable, Key edgeSourceKey, VertexTable destinationVertexTable, Key edgeDestinationKey, List<Label> labels) {
        this(tableName, tableName.getName(), null, sourceVertexTable, edgeSourceKey, null, destinationVertexTable, edgeDestinationKey, null, labels);
    }

    public EdgeTable(SchemaQualifiedName tableName, String tableAlias, VertexTable sourceVertexTable, Key edgeSourceKey, VertexTable destinationVertexTable, Key edgeDestinationKey, List<Label> labels) {
        this(tableName, tableAlias, null, sourceVertexTable, edgeSourceKey, null, destinationVertexTable, edgeDestinationKey, null, labels);
    }

    public EdgeTable(SchemaQualifiedName tableName, String tableAlias, Key key, VertexTable sourceVertexTable, Key edgeSourceKey, Key sourceVertexKey, VertexTable destinationVertexTable, Key edgeDestinationKey, Key destinationVertexKey, List<Label> labels) {
        super(key, tableName, tableAlias, labels);
        this.sourceVertexTable = sourceVertexTable;
        this.edgeSourceKey = edgeSourceKey;
        this.sourceVertexKey = sourceVertexKey;
        this.destinationVertexTable = destinationVertexTable;
        this.edgeDestinationKey = edgeDestinationKey;
        this.destinationVertexKey = destinationVertexKey;
    }

    public VertexTable getSourceVertexTable() {
        return this.sourceVertexTable;
    }

    public void setSourceVertexTable(VertexTable sourceVertexTable) {
        this.sourceVertexTable = sourceVertexTable;
    }

    public Key getEdgeSourceKey() {
        return this.edgeSourceKey;
    }

    public void setEdgeSourceKey(Key edgeSourceKey) {
        this.edgeSourceKey = edgeSourceKey;
    }

    public Key getSourceVertexKey() {
        return this.sourceVertexKey;
    }

    public void setSourceVertexKey(Key sourceVertexKey) {
        this.sourceVertexKey = sourceVertexKey;
    }

    public VertexTable getDestinationVertexTable() {
        return this.destinationVertexTable;
    }

    public void setDestinationVertexTable(VertexTable destinationVertexTable) {
        this.destinationVertexTable = destinationVertexTable;
    }

    public Key getEdgeDestinationKey() {
        return this.edgeDestinationKey;
    }

    public void setEdgeDestinationKey(Key edgeDestinationKey) {
        this.edgeDestinationKey = edgeDestinationKey;
    }

    public Key getDestinationVertexKey() {
        return this.destinationVertexKey;
    }

    public void setDestinationVertexKey(Key destinationVertexKey) {
        this.destinationVertexKey = destinationVertexKey;
    }

    public String toString() {
        return this.getTableName().toString(true) + this.printAlias(" ") + this.printKey(" ") + this.printSource() + this.printDestination() + this.printLabels("\n      ");
    }

    private String printSource() {
        return "\n      SOURCE " + this.printVertexTableReference(this.edgeSourceKey, this.sourceVertexTable, this.sourceVertexKey);
    }

    private String printDestination() {
        return "\n      DESTINATION " + this.printVertexTableReference(this.edgeDestinationKey, this.destinationVertexTable, this.destinationVertexKey);
    }

    private String printVertexTableReference(Key key, VertexTable referencedVertexTable, Key refercedTableKey) {
        String vertexTableName;
        String string = vertexTableName = referencedVertexTable.getTableAlias() == null ? referencedVertexTable.getTableName().getName() : referencedVertexTable.getTableAlias();
        if (key == null) {
            return PgqlUtils.printIdentifier(vertexTableName);
        }
        return "KEY " + key + " REFERENCES " + PgqlUtils.printIdentifier(vertexTableName) + this.printKeyForReferencedVertexTable(refercedTableKey);
    }

    private String printKeyForReferencedVertexTable(Key vertexKey) {
        if (vertexKey == null) {
            return "";
        }
        return vertexKey.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        EdgeTable other = (EdgeTable)obj;
        if (this.destinationVertexKey == null ? other.destinationVertexKey != null : !this.destinationVertexKey.equals(other.destinationVertexKey)) {
            return false;
        }
        if (this.destinationVertexTable == null ? other.destinationVertexTable != null : !this.destinationVertexTable.equals(other.destinationVertexTable)) {
            return false;
        }
        if (this.edgeDestinationKey == null ? other.edgeDestinationKey != null : !this.edgeDestinationKey.equals(other.edgeDestinationKey)) {
            return false;
        }
        if (this.edgeSourceKey == null ? other.edgeSourceKey != null : !this.edgeSourceKey.equals(other.edgeSourceKey)) {
            return false;
        }
        if (this.sourceVertexKey == null ? other.sourceVertexKey != null : !this.sourceVertexKey.equals(other.sourceVertexKey)) {
            return false;
        }
        return !(this.sourceVertexTable == null ? other.sourceVertexTable != null : !this.sourceVertexTable.equals(other.sourceVertexTable));
    }
}

