/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.StatementType;

public class CreatePropertyGraph
implements PgqlStatement {
    private SchemaQualifiedName graphName;
    private List<VertexTable> vertexTables;
    private List<EdgeTable> edgeTables;
    private List<String> options;

    public CreatePropertyGraph(SchemaQualifiedName graphName, List<VertexTable> vertexTables, List<EdgeTable> edgeTables) {
        this.graphName = graphName;
        this.options = null;
        this.vertexTables = vertexTables;
        this.edgeTables = edgeTables;
    }

    public SchemaQualifiedName getGraphName() {
        return this.graphName;
    }

    public void setGraphName(SchemaQualifiedName graphName) {
        this.graphName = graphName;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public List<VertexTable> getVertexTables() {
        return this.vertexTables;
    }

    public void setVertexTables(List<VertexTable> vertexTables) {
        this.vertexTables = vertexTables;
    }

    public List<EdgeTable> getEdgeTables() {
        return this.edgeTables;
    }

    public void setEdgeTables(List<EdgeTable> edgeTables) {
        this.edgeTables = edgeTables;
    }

    public String toString() {
        return "CREATE PROPERTY GRAPH " + this.graphName + this.printVertexTables() + this.printEdgeTables() + this.printOptions();
    }

    private String printOptions() {
        if (this.options == null) {
            return "";
        }
        return "\n  OPTIONS( " + this.options.stream().collect(Collectors.joining(", ")) + " )";
    }

    private String printVertexTables() {
        if (this.vertexTables.isEmpty()) {
            return "";
        }
        return "\n  VERTEX TABLES (\n    " + this.vertexTables.stream().map(x -> x.toString()).collect(Collectors.joining(",\n    ")) + "\n  )";
    }

    private String printEdgeTables() {
        if (this.edgeTables.isEmpty()) {
            return "";
        }
        return "\n  EDGE TABLES (\n    " + this.edgeTables.stream().map(x -> x.toString()).collect(Collectors.joining(",\n    ")) + "\n  )";
    }

    @Override
    public StatementType getStatementType() {
        return StatementType.CREATE_PROPERTY_GRAPH;
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreatePropertyGraph other = (CreatePropertyGraph)obj;
        if (this.edgeTables == null ? other.edgeTables != null : !this.edgeTables.equals(other.edgeTables)) {
            return false;
        }
        if (this.graphName == null ? other.graphName != null : !this.graphName.equals(other.graphName)) {
            return false;
        }
        if (this.vertexTables == null ? other.vertexTables != null : !this.vertexTables.equals(other.vertexTables)) {
            return false;
        }
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }
}

