/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.common.base.Formatting;
import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.util.BitSet;

public class BitSetConverter
implements JsonbAdapter<BitSet, byte[]>,
Converter<BitSet> {
    public static final BitSetConverter INSTANCE = new BitSetConverter();

    @Override
    public void serialize(BitSet bitSet, ObjectWriter writer, Context context) throws Exception {
        writer.writeString(Formatting.toHexEscape((byte[])bitSet.toByteArray()));
    }

    @Override
    public BitSet deserialize(ObjectReader reader, Context context) throws Exception {
        byte[] bytes = Formatting.parseHex((String)reader.valueAsString());
        return BitSet.valueOf(bytes);
    }

    public byte[] adaptToJson(BitSet bits) {
        return bits.toByteArray();
    }

    public BitSet adaptFromJson(byte[] bytes) throws Exception {
        return BitSet.valueOf(bytes);
    }
}

