/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson;

import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class GenericType<T> {
    private final Type type;
    private final Class<T> rawClass;

    protected GenericType() {
        Type superType = this.getClass().getGenericSuperclass();
        if (superType instanceof Class) {
            throw new IllegalArgumentException("You must specify the parametrized type!");
        }
        this.type = ((ParameterizedType)superType).getActualTypeArguments()[0];
        this.rawClass = TypeUtil.getRawClass(this.type);
    }

    private GenericType(Class<T> rawClass) {
        this.type = rawClass;
        this.rawClass = rawClass;
    }

    private GenericType(Type type) {
        this.type = type;
        this.rawClass = TypeUtil.getRawClass(type);
    }

    public static <T> GenericType<T> of(Class<T> rawClass) {
        return new GenericType<T>((Class)rawClass){};
    }

    public static GenericType<Object> of(Type type) {
        return new GenericType<Object>(type){};
    }

    public Type getType() {
        return this.type;
    }

    public Class<T> getRawClass() {
        return this.rawClass;
    }
}

