/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.ext.jsr353.JSR353Bundle;
import com.oracle.coherence.io.json.genson.reflect.Evolvable;
import com.oracle.coherence.io.json.genson.reflect.UnknownPropertyHandler;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.function.Consumer;

public class EvolvableHandler
implements UnknownPropertyHandler {
    private static final Converter<JsonValue> CONVERTER = new JSR353Bundle.JsonValueConverter();

    @Override
    public <T> Consumer<T> readUnknownProperty(String propName, ObjectReader reader, Context ctx) {
        try {
            JsonValue propValue = CONVERTER.deserialize(reader, ctx);
            return objTarget -> {
                if (objTarget instanceof Evolvable) {
                    ((Evolvable)objTarget).addUnknownProperty(propName, propValue);
                }
            };
        }
        catch (Exception e) {
            throw new JsonBindingException(e);
        }
    }

    @Override
    public <T> void writeUnknownProperties(T bean, ObjectWriter writer, Context ctx) {
        try {
            Map<String, JsonValue> props;
            if (bean instanceof Evolvable && (props = ((Evolvable)bean).unknownProperties()) != null) {
                for (String propName : props.keySet()) {
                    writer.writeName(propName);
                    CONVERTER.serialize(props.get(propName), writer, ctx);
                }
            }
        }
        catch (Exception e) {
            throw new JsonBindingException(e);
        }
    }
}

