/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import com.oracle.coherence.io.json.genson.EncodingAwareReaderFactory;
import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonBuilderFactory;
import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonParserFactory;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class GensonJsonReaderFactory
implements JsonReaderFactory {
    private final GensonJsonParserFactory parserFactory;
    private final GensonJsonBuilderFactory builderFactory;
    private final EncodingAwareReaderFactory encodingAwareReaderFactory = new EncodingAwareReaderFactory();

    public GensonJsonReaderFactory() {
        this(Collections.emptyMap());
    }

    public GensonJsonReaderFactory(Map<String, ?> config) {
        this.parserFactory = new GensonJsonParserFactory(config);
        this.builderFactory = new GensonJsonBuilderFactory();
    }

    public JsonReader createReader(final Reader reader) {
        return new JsonReader(){
            private final JsonParser parser;
            private boolean readed;
            {
                this.parser = GensonJsonReaderFactory.this.parserFactory.createParser(reader);
                this.readed = false;
            }

            public JsonStructure read() {
                this.checkNotReadedAndRead();
                if (this.parser.hasNext()) {
                    JsonParser.Event evt = this.parser.next();
                    if (JsonParser.Event.START_OBJECT == evt) {
                        return this.read(GensonJsonReaderFactory.this.builderFactory.createObjectBuilder()).build();
                    }
                    if (JsonParser.Event.START_ARRAY == evt) {
                        return this.read(GensonJsonReaderFactory.this.builderFactory.createArrayBuilder()).build();
                    }
                    throw new JsonException("Expected START_OBJECT or START_ARRAY but got " + String.valueOf(evt));
                }
                throw new JsonException("Empty stream");
            }

            public JsonObject readObject() {
                this.checkNotReadedAndRead();
                if (this.parser.hasNext()) {
                    JsonParser.Event evt = this.parser.next();
                    if (JsonParser.Event.START_OBJECT == evt) {
                        return this.read(GensonJsonReaderFactory.this.builderFactory.createObjectBuilder()).build();
                    }
                    throw new JsonException("Expected " + String.valueOf(JsonParser.Event.START_OBJECT) + " but got " + String.valueOf(evt));
                }
                throw new JsonException("Empty stream");
            }

            public JsonArray readArray() {
                this.checkNotReadedAndRead();
                if (this.parser.hasNext()) {
                    JsonParser.Event evt = this.parser.next();
                    if (JsonParser.Event.START_ARRAY == evt) {
                        return this.read(GensonJsonReaderFactory.this.builderFactory.createArrayBuilder()).build();
                    }
                    throw new JsonException("Expected " + String.valueOf(JsonParser.Event.START_ARRAY) + " but got " + String.valueOf(evt));
                }
                throw new JsonException("Empty stream");
            }

            private JsonArrayBuilder read(JsonArrayBuilder arrayBuilder) {
                block10: while (this.parser.hasNext()) {
                    JsonParser.Event evt = this.parser.next();
                    switch (evt) {
                        case VALUE_STRING: {
                            arrayBuilder.add(this.parser.getString());
                            continue block10;
                        }
                        case VALUE_NUMBER: {
                            if (this.parser.isIntegralNumber()) {
                                arrayBuilder.add(this.parser.getLong());
                                continue block10;
                            }
                            arrayBuilder.add(this.parser.getBigDecimal());
                            continue block10;
                        }
                        case VALUE_NULL: {
                            arrayBuilder.addNull();
                            continue block10;
                        }
                        case VALUE_FALSE: {
                            arrayBuilder.add(JsonValue.FALSE);
                            continue block10;
                        }
                        case VALUE_TRUE: {
                            arrayBuilder.add(JsonValue.TRUE);
                            continue block10;
                        }
                        case START_OBJECT: {
                            arrayBuilder.add(this.read(GensonJsonReaderFactory.this.builderFactory.createObjectBuilder()));
                            continue block10;
                        }
                        case START_ARRAY: {
                            arrayBuilder.add(this.read(GensonJsonReaderFactory.this.builderFactory.createArrayBuilder()));
                            continue block10;
                        }
                        case END_ARRAY: {
                            return arrayBuilder;
                        }
                    }
                    throw new JsonException("Unexpected event " + String.valueOf(evt));
                }
                throw new IllegalStateException();
            }

            private JsonObjectBuilder read(JsonObjectBuilder objectBuilder) {
                String name = null;
                block11: while (this.parser.hasNext()) {
                    JsonParser.Event evt = this.parser.next();
                    switch (evt) {
                        case KEY_NAME: {
                            name = this.parser.getString();
                            continue block11;
                        }
                        case VALUE_STRING: {
                            objectBuilder.add(name, this.parser.getString());
                            continue block11;
                        }
                        case VALUE_NUMBER: {
                            if (this.parser.isIntegralNumber()) {
                                objectBuilder.add(name, this.parser.getLong());
                                continue block11;
                            }
                            objectBuilder.add(name, this.parser.getBigDecimal());
                            continue block11;
                        }
                        case VALUE_NULL: {
                            objectBuilder.addNull(name);
                            continue block11;
                        }
                        case VALUE_FALSE: {
                            objectBuilder.add(name, JsonValue.FALSE);
                            continue block11;
                        }
                        case VALUE_TRUE: {
                            objectBuilder.add(name, JsonValue.TRUE);
                            continue block11;
                        }
                        case START_OBJECT: {
                            objectBuilder.add(name, this.read(GensonJsonReaderFactory.this.builderFactory.createObjectBuilder()));
                            continue block11;
                        }
                        case START_ARRAY: {
                            objectBuilder.add(name, this.read(GensonJsonReaderFactory.this.builderFactory.createArrayBuilder()));
                            continue block11;
                        }
                        case END_OBJECT: {
                            return objectBuilder;
                        }
                    }
                    throw new JsonException("Unknown Event " + String.valueOf(evt));
                }
                throw new IllegalStateException();
            }

            public void close() {
                this.parser.close();
            }

            private void checkNotReadedAndRead() {
                if (this.readed) {
                    throw new IllegalStateException();
                }
                this.readed = true;
            }
        };
    }

    public JsonReader createReader(InputStream in) {
        try {
            return this.createReader(this.encodingAwareReaderFactory.createReader(in));
        }
        catch (IOException e) {
            throw new JsonException("Failed to detect encoding.", (Throwable)e);
        }
    }

    public JsonReader createReader(InputStream in, Charset charset) {
        return this.createReader(new InputStreamReader(in, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return this.parserFactory.getConfigInUse();
    }
}

