/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.common.collections.ConcurrentHashMap;
import java.io.ObjectInputFilter;

public class SerializationGate {
    private static final ConcurrentHashMap<String, Boolean> RESULT_CACHE = new ConcurrentHashMap();

    public static boolean isValid(Class<?> clz) {
        String sClass = clz.getName();
        return (Boolean)RESULT_CACHE.computeIfAbsent((Object)sClass, s -> {
            ObjectInputFilter filter = ObjectInputFilter.Config.getSerialFilter();
            return filter == null || ObjectInputFilter.Config.getSerialFilter().checkInput(new FilterInfo(clz)) != ObjectInputFilter.Status.REJECTED;
        });
    }

    public static class FilterInfo
    implements ObjectInputFilter.FilterInfo {
        private final Class<?> f_clz;

        public FilterInfo(Class<?> clz) {
            this.f_clz = clz;
        }

        @Override
        public Class<?> serialClass() {
            return this.f_clz;
        }

        @Override
        public long arrayLength() {
            return -1L;
        }

        @Override
        public long depth() {
            return 1L;
        }

        @Override
        public long references() {
            return 0L;
        }

        @Override
        public long streamBytes() {
            return 0L;
        }
    }
}

