/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.stream.JsonStreamException;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.internal.InetAddressConverter;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InetSocketAddressConverter
implements Converter<InetSocketAddress> {
    public static final InetSocketAddressConverter INSTANCE = new InetSocketAddressConverter();

    protected InetSocketAddressConverter() {
    }

    @Override
    public void serialize(InetSocketAddress address, ObjectWriter writer, Context ctx) throws Exception {
        writer.beginObject();
        writer.writeName("address");
        InetAddressConverter.INSTANCE.serialize(address.getAddress(), writer, ctx);
        writer.writeNumber("port", address.getPort());
        writer.endObject();
    }

    @Override
    public InetSocketAddress deserialize(ObjectReader reader, Context ctx) throws Exception {
        InetAddress host = null;
        int port = 0;
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            if ("address".equals(reader.name())) {
                host = InetAddressConverter.INSTANCE.deserialize(reader, ctx);
                continue;
            }
            if (!"port".equals(reader.name())) continue;
            port = reader.valueAsInt();
        }
        reader.endObject();
        if (host == null) {
            throw new JsonStreamException("Unable to deserialize InetSocketAddress; address missing");
        }
        return new InetSocketAddress(host.getHostAddress(), port);
    }
}

