/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.annotation.JsonProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public interface PropertyNameResolver {
    public String resolve(int var1, Constructor<?> var2);

    public String resolve(int var1, Method var2);

    public String resolve(Field var1);

    public String resolve(Method var1);

    public static class GensonAnnotationPropertyNameResolver
    extends AnnotationPropertyNameResolver<JsonProperty> {
        public GensonAnnotationPropertyNameResolver() {
            super(JsonProperty.class);
        }

        @Override
        protected String getNameFromAnnotation(JsonProperty annotation) {
            return annotation.value();
        }
    }

    public static abstract class AnnotationPropertyNameResolver<A extends Annotation>
    implements PropertyNameResolver {
        protected Class<A> propertyAnnotation;

        public AnnotationPropertyNameResolver(Class<A> propertyAnnotation) {
            this.propertyAnnotation = propertyAnnotation;
        }

        @Override
        public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
            return this.getNameFromParameterAnnotations(fromConstructor.getParameterAnnotations()[parameterIdx]);
        }

        @Override
        public String resolve(int parameterIdx, Method fromMethod) {
            return this.getNameFromParameterAnnotations(fromMethod.getParameterAnnotations()[parameterIdx]);
        }

        @Override
        public String resolve(Field fromField) {
            return this.getName(fromField);
        }

        @Override
        public String resolve(Method fromMethod) {
            return this.getName(fromMethod);
        }

        protected String getName(AnnotatedElement annElement) {
            A annotation = annElement.getAnnotation(this.propertyAnnotation);
            if (annotation != null) {
                String name = this.getNameFromAnnotation(annotation);
                return "".equals(name) ? null : name;
            }
            return null;
        }

        protected String getNameFromParameterAnnotations(Annotation[] annotations) {
            String name = null;
            for (Annotation annotation : annotations) {
                if (!this.propertyAnnotation.isInstance(annotation)) continue;
                name = this.getNameFromAnnotation(annotation);
                break;
            }
            return "".equals(name) ? null : name;
        }

        protected abstract String getNameFromAnnotation(A var1);
    }

    public static class ConventionalBeanPropertyNameResolver
    implements PropertyNameResolver {
        @Override
        public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
            return null;
        }

        @Override
        public String resolve(Field fromField) {
            return fromField.getName();
        }

        @Override
        public String resolve(Method fromMethod) {
            String name = fromMethod.getName();
            int length = -1;
            if (name.startsWith("get")) {
                length = 3;
            } else if (name.startsWith("is")) {
                length = 2;
            } else if (name.startsWith("set")) {
                length = 3;
            }
            if (length > -1 && length < name.length()) {
                return Character.toLowerCase(name.charAt(length)) + name.substring(length + 1);
            }
            return null;
        }

        @Override
        public String resolve(int parameterIdx, Method fromMethod) {
            return null;
        }
    }

    public static class CompositePropertyNameResolver
    implements PropertyNameResolver {
        private List<PropertyNameResolver> components;

        public CompositePropertyNameResolver(List<PropertyNameResolver> components) {
            if (components == null || components.isEmpty()) {
                throw new IllegalArgumentException("The composite resolver must have at least one resolver as component!");
            }
            this.components = new LinkedList<PropertyNameResolver>(components);
        }

        public CompositePropertyNameResolver add(PropertyNameResolver ... resolvers) {
            this.components.addAll(0, Arrays.asList(resolvers));
            return this;
        }

        @Override
        public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(parameterIdx, fromConstructor);
            }
            return resolvedName;
        }

        @Override
        public String resolve(int parameterIdx, Method fromMethod) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(parameterIdx, fromMethod);
            }
            return resolvedName;
        }

        @Override
        public String resolve(Field fromField) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(fromField);
            }
            return resolvedName;
        }

        @Override
        public String resolve(Method fromMethod) {
            String resolvedName = null;
            Iterator<PropertyNameResolver> it = this.components.iterator();
            while (resolvedName == null && it.hasNext()) {
                resolvedName = it.next().resolve(fromMethod);
            }
            return resolvedName;
        }
    }
}

