/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.datetime;

import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.GensonBuilder;
import com.oracle.coherence.io.json.genson.annotation.JsonDateFormat;
import com.oracle.coherence.io.json.genson.convert.ContextualFactory;
import com.oracle.coherence.io.json.genson.datetime.DateTimeConverterOptions;
import com.oracle.coherence.io.json.genson.datetime.InstantConverter;
import com.oracle.coherence.io.json.genson.datetime.LocalDateConverter;
import com.oracle.coherence.io.json.genson.datetime.LocalDateTimeConverter;
import com.oracle.coherence.io.json.genson.datetime.LocalTimeConverter;
import com.oracle.coherence.io.json.genson.datetime.MonthDayConverter;
import com.oracle.coherence.io.json.genson.datetime.OffsetDateTimeConverter;
import com.oracle.coherence.io.json.genson.datetime.OffsetTimeConverter;
import com.oracle.coherence.io.json.genson.datetime.TemporalAmountConverter;
import com.oracle.coherence.io.json.genson.datetime.TimestampFormat;
import com.oracle.coherence.io.json.genson.datetime.YearConverter;
import com.oracle.coherence.io.json.genson.datetime.YearMonthConverter;
import com.oracle.coherence.io.json.genson.datetime.ZoneIdConverter;
import com.oracle.coherence.io.json.genson.datetime.ZoneOffsetConverter;
import com.oracle.coherence.io.json.genson.datetime.ZonedDateTimeConverter;
import com.oracle.coherence.io.json.genson.datetime.annotation.JsonTimestampFormat;
import com.oracle.coherence.io.json.genson.datetime.annotation.JsonZoneId;
import com.oracle.coherence.io.json.genson.ext.GensonBundle;
import com.oracle.coherence.io.json.genson.reflect.BeanProperty;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public class JavaDateTimeBundle
extends GensonBundle {
    private ZoneId zoneId = ZoneId.systemDefault();
    private Map<Class<?>, ConverterGenerator> converterGenerators = new HashMap();
    private Map<Class<? extends TemporalAccessor>, TimestampFormat> temporalAccessorTimestampFormats = new HashMap<Class<? extends TemporalAccessor>, TimestampFormat>();
    private Map<Class<? extends TemporalAmount>, TimestampFormat> temporalAmountTimestampFormats = new HashMap<Class<? extends TemporalAmount>, TimestampFormat>();
    private Map<Class<?>, DateTimeFormatter> formatters = new HashMap();

    public JavaDateTimeBundle() {
        this.registerConverterGenerator(Instant.class, InstantConverter::new);
        this.registerConverterGenerator(ZonedDateTime.class, ZonedDateTimeConverter::new);
        this.registerConverterGenerator(OffsetDateTime.class, OffsetDateTimeConverter::new);
        this.registerConverterGenerator(LocalDateTime.class, LocalDateTimeConverter::new);
        this.registerConverterGenerator(LocalDate.class, LocalDateConverter::new);
        this.registerConverterGenerator(LocalTime.class, LocalTimeConverter::new);
        this.registerConverterGenerator(Year.class, YearConverter::new);
        this.registerConverterGenerator(YearMonth.class, YearMonthConverter::new);
        this.registerConverterGenerator(MonthDay.class, MonthDayConverter::new);
        this.registerConverterGenerator(OffsetTime.class, OffsetTimeConverter::new);
        this.registerConverterGenerator(Period.class, TemporalAmountConverter::period);
        this.registerConverterGenerator(Duration.class, TemporalAmountConverter::duration);
        this.temporalAccessorTimestampFormats.put(Instant.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(ZonedDateTime.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(OffsetDateTime.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(LocalDateTime.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(LocalDate.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(LocalTime.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(Year.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(YearMonth.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(MonthDay.class, TimestampFormat.OBJECT);
        this.temporalAccessorTimestampFormats.put(OffsetTime.class, TimestampFormat.OBJECT);
        this.temporalAmountTimestampFormats.put(Period.class, TimestampFormat.OBJECT);
        this.temporalAmountTimestampFormats.put(Duration.class, TimestampFormat.OBJECT);
        this.formatters.put(Instant.class, DateTimeFormatter.ISO_INSTANT);
        this.formatters.put(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        this.formatters.put(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.formatters.put(LocalDateTime.class, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        this.formatters.put(LocalDate.class, DateTimeFormatter.ISO_LOCAL_DATE);
        this.formatters.put(LocalTime.class, DateTimeFormatter.ISO_LOCAL_TIME);
        this.formatters.put(OffsetTime.class, DateTimeFormatter.ISO_OFFSET_TIME);
        this.formatters.put(Year.class, DateTimeFormatter.ofPattern("uuuu"));
        this.formatters.put(YearMonth.class, DateTimeFormatter.ofPattern("uuuu-MM"));
        this.formatters.put(MonthDay.class, DateTimeFormatter.ofPattern("MM-dd"));
    }

    @Override
    public void configure(GensonBuilder builder) {
        boolean asTimestamp = builder.isDateAsTimestamp();
        builder.withContextualFactory(new JavaDateTimeContextualFactory(asTimestamp));
        for (Map.Entry<Class<?>, ConverterGenerator> converterGeneratorEntry : this.converterGenerators.entrySet()) {
            Class<?> clazz = converterGeneratorEntry.getKey();
            ConverterGenerator converterGenerator = converterGeneratorEntry.getValue();
            DateTimeFormatter formatter = this.formatters.get(clazz);
            DateTimeConverterOptions options = new DateTimeConverterOptions(clazz, formatter, asTimestamp, this.getDefaultTimestampFormat(clazz), this.zoneId);
            Converter converter = converterGenerator.createConverter(options);
            builder.withConverters(converter);
        }
        builder.withConverter(new ZoneOffsetConverter(), ZoneOffset.class);
        builder.withConverterFactory(new ZoneIdConverter.Factory());
    }

    private TimestampFormat getDefaultTimestampFormat(Class<?> clazz) {
        if (TemporalAmount.class.isAssignableFrom(clazz)) {
            return this.temporalAmountTimestampFormats.get(clazz);
        }
        return this.temporalAccessorTimestampFormats.get(clazz);
    }

    private <T> void registerConverterGenerator(Class<T> clazz, Function<DateTimeConverterOptions, Converter<T>> converterGeneratorFunction) {
        ConverterGenerator<T> converterGenerator = new ConverterGenerator<T>(converterGeneratorFunction);
        this.converterGenerators.put(clazz, converterGenerator);
    }

    public JavaDateTimeBundle setFormatter(Class<? extends TemporalAccessor> clazz, DateTimeFormatter formatter) {
        this.formatters.put(clazz, formatter);
        return this;
    }

    public JavaDateTimeBundle setTemporalAccessorTimestampFormat(Class<? extends TemporalAccessor> clazz, TimestampFormat format) {
        this.temporalAccessorTimestampFormats.put(clazz, format);
        return this;
    }

    public JavaDateTimeBundle setTemporalAmountTimestampFormat(Class<? extends TemporalAmount> clazz, TimestampFormat format) {
        this.temporalAmountTimestampFormats.put(clazz, format);
        return this;
    }

    public JavaDateTimeBundle setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    private class ConverterGenerator<T> {
        private Function<DateTimeConverterOptions, Converter<T>> converterGeneratorFunction;

        ConverterGenerator(Function<DateTimeConverterOptions, Converter<T>> converterGeneratorFunction) {
            this.converterGeneratorFunction = converterGeneratorFunction;
        }

        Converter<T> createConverter(DateTimeConverterOptions options) {
            return this.converterGeneratorFunction.apply(options);
        }
    }

    private class JavaDateTimeContextualFactory
    implements ContextualFactory {
        private boolean timestampByDefault;

        private JavaDateTimeContextualFactory(boolean timestampByDefault) {
            this.timestampByDefault = timestampByDefault;
        }

        public Converter create(BeanProperty property, Genson genson) {
            if (this.hasRelevantAnnotation(property)) {
                Class<?> rawClass = property.getRawClass();
                for (Map.Entry<Class<?>, ConverterGenerator> supportedType : JavaDateTimeBundle.this.converterGenerators.entrySet()) {
                    Class<?> clazz = supportedType.getKey();
                    ConverterGenerator generator = supportedType.getValue();
                    if (!clazz.isAssignableFrom(rawClass)) continue;
                    DateTimeConverterOptions options = this.createOptions(property, clazz);
                    return generator.createConverter(options);
                }
            }
            return null;
        }

        private DateTimeConverterOptions createOptions(BeanProperty property, Class<?> clazz) {
            JsonDateFormat jsonDateFormat = property.getAnnotation(JsonDateFormat.class);
            DateTimeFormatter formatter = this.getFormatter(jsonDateFormat, JavaDateTimeBundle.this.formatters.get(clazz));
            boolean asTimestamp = jsonDateFormat == null ? this.timestampByDefault : jsonDateFormat.asTimeInMillis();
            ZoneId zoneId = this.getZoneId(property);
            TimestampFormat timestampFormat = this.getTimestampFormat(property, JavaDateTimeBundle.this.getDefaultTimestampFormat(clazz));
            return new DateTimeConverterOptions(clazz, formatter, asTimestamp, timestampFormat, zoneId);
        }

        private DateTimeFormatter getFormatter(JsonDateFormat ann, DateTimeFormatter defaultFormatter) {
            if (ann == null || ann.value().isEmpty()) {
                return defaultFormatter;
            }
            Locale locale = ann.lang().isEmpty() ? Locale.getDefault() : new Locale(ann.lang());
            return DateTimeFormatter.ofPattern(ann.value()).withLocale(locale);
        }

        private TimestampFormat getTimestampFormat(BeanProperty property, TimestampFormat defaultTimestampFormat) {
            JsonTimestampFormat ann = property.getAnnotation(JsonTimestampFormat.class);
            return ann == null ? defaultTimestampFormat : ann.value();
        }

        private ZoneId getZoneId(BeanProperty property) {
            JsonZoneId ann = property.getAnnotation(JsonZoneId.class);
            return ann == null || ann.value().isEmpty() ? JavaDateTimeBundle.this.zoneId : ZoneId.of(ann.value());
        }

        private boolean hasRelevantAnnotation(BeanProperty property) {
            JsonDateFormat formatAnn = property.getAnnotation(JsonDateFormat.class);
            JsonZoneId zoneIdAnn = property.getAnnotation(JsonZoneId.class);
            JsonTimestampFormat timestampFormatAnn = property.getAnnotation(JsonTimestampFormat.class);
            return formatAnn != null || zoneIdAnn != null || timestampFormatAnn != null;
        }
    }
}

