/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.internal.IPAddressUtil;
import java.net.InetAddress;

public class InetAddressConverter
implements Converter<InetAddress> {
    public static final InetAddressConverter INSTANCE = new InetAddressConverter();

    protected InetAddressConverter() {
    }

    @Override
    public void serialize(InetAddress address, ObjectWriter writer, Context ctx) throws Exception {
        writer.beginObject();
        writer.writeString("host", address.getHostName());
        writer.writeString("address", address.getHostAddress());
        writer.endObject();
    }

    @Override
    public InetAddress deserialize(ObjectReader reader, Context ctx) throws Exception {
        String host = null;
        String address = null;
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            if ("host".equals(reader.name())) {
                host = reader.valueAsString();
                continue;
            }
            if (!"address".equals(reader.name())) continue;
            address = reader.valueAsString();
        }
        reader.endObject();
        return address == null ? (host == null ? null : InetAddress.getByName(host)) : (host == null ? InetAddress.getByAddress(InetAddressConverter.toBytes(address)) : InetAddress.getByAddress(host, InetAddressConverter.toBytes(address)));
    }

    protected static byte[] toBytes(String address) {
        return address.indexOf(46) > 0 ? IPAddressUtil.textToNumericFormatV4(address) : IPAddressUtil.textToNumericFormatV6(address);
    }
}

