/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.reflect.BeanCreator;
import com.oracle.coherence.io.json.genson.reflect.PropertyAccessor;
import com.oracle.coherence.io.json.genson.reflect.PropertyMutator;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public interface BeanPropertyFactory {
    public PropertyAccessor createAccessor(String var1, Field var2, Type var3, Genson var4);

    public PropertyAccessor createAccessor(String var1, Method var2, Type var3, Genson var4);

    public BeanCreator createCreator(Type var1, Constructor<?> var2, String[] var3, boolean var4, Genson var5);

    public BeanCreator createCreator(Type var1, Method var2, String[] var3, boolean var4, Genson var5);

    public PropertyMutator createMutator(String var1, Field var2, Type var3, Genson var4);

    public PropertyMutator createMutator(String var1, Method var2, Type var3, Genson var4);

    public static class StandardFactory
    implements BeanPropertyFactory {
        @Override
        public PropertyAccessor createAccessor(String name, Field field, Type ofType, Genson genson) {
            Class<?> ofClass = TypeUtil.getRawClass(ofType);
            Type expandedType = TypeUtil.expandType(field.getGenericType(), ofType);
            return new PropertyAccessor.FieldAccessor(name, field, expandedType, ofClass);
        }

        @Override
        public PropertyAccessor createAccessor(String name, Method method, Type ofType, Genson genson) {
            Type expandedType = TypeUtil.expandType(method.getGenericReturnType(), ofType);
            return new PropertyAccessor.MethodAccessor(name, method, expandedType, TypeUtil.getRawClass(ofType));
        }

        @Override
        public PropertyMutator createMutator(String name, Field field, Type ofType, Genson genson) {
            Class<?> ofClass = TypeUtil.getRawClass(ofType);
            Type expandedType = TypeUtil.expandType(field.getGenericType(), ofType);
            return new PropertyMutator.FieldMutator(name, field, expandedType, ofClass);
        }

        @Override
        public PropertyMutator createMutator(String name, Method method, Type ofType, Genson genson) {
            Type expandedType = TypeUtil.expandType(method.getGenericParameterTypes()[0], ofType);
            return new PropertyMutator.MethodMutator(name, method, expandedType, TypeUtil.getRawClass(ofType));
        }

        @Override
        public BeanCreator createCreator(Type ofType, Method method, String[] resolvedNames, boolean annotated, Genson genson) {
            return new BeanCreator.MethodBeanCreator(method, resolvedNames, this.expandTypes(method.getGenericParameterTypes(), ofType), TypeUtil.getRawClass(ofType), annotated);
        }

        @Override
        public BeanCreator createCreator(Type ofType, Constructor<?> ctr, String[] resolvedNames, boolean annotated, Genson genson) {
            return new BeanCreator.ConstructorBeanCreator(TypeUtil.getRawClass(ofType), ctr, resolvedNames, this.expandTypes(ctr.getGenericParameterTypes(), ofType), annotated);
        }

        public Type[] expandTypes(Type[] typesToExpand, Type inContext) {
            Type[] expandedTypes = new Type[typesToExpand.length];
            for (int i = 0; i < typesToExpand.length; ++i) {
                expandedTypes[i] = TypeUtil.expandType(typesToExpand[i], inContext);
            }
            return expandedTypes;
        }
    }

    public static class CompositeFactory
    implements BeanPropertyFactory {
        private final List<BeanPropertyFactory> factories;

        public CompositeFactory(List<? extends BeanPropertyFactory> factories) {
            this.factories = new ArrayList<BeanPropertyFactory>(factories);
        }

        @Override
        public PropertyAccessor createAccessor(String name, Field field, Type ofType, Genson genson) {
            for (BeanPropertyFactory factory : this.factories) {
                PropertyAccessor accessor = factory.createAccessor(name, field, ofType, genson);
                if (accessor == null) continue;
                return accessor;
            }
            throw new RuntimeException("Failed to create a accessor for field " + field);
        }

        @Override
        public PropertyAccessor createAccessor(String name, Method method, Type ofType, Genson genson) {
            for (BeanPropertyFactory factory : this.factories) {
                PropertyAccessor accessor = factory.createAccessor(name, method, ofType, genson);
                if (accessor == null) continue;
                return accessor;
            }
            throw new RuntimeException("Failed to create a accessor for method " + method);
        }

        @Override
        public BeanCreator createCreator(Type ofType, Constructor<?> ctr, String[] resolvedNames, boolean annotated, Genson genson) {
            for (BeanPropertyFactory factory : this.factories) {
                BeanCreator creator = factory.createCreator(ofType, ctr, resolvedNames, annotated, genson);
                if (creator == null) continue;
                return creator;
            }
            throw new RuntimeException("Failed to create a BeanCreator for constructor " + ctr);
        }

        @Override
        public BeanCreator createCreator(Type ofType, Method method, String[] resolvedNames, boolean annotated, Genson genson) {
            for (BeanPropertyFactory factory : this.factories) {
                BeanCreator creator = factory.createCreator(ofType, method, resolvedNames, annotated, genson);
                if (creator == null) continue;
                return creator;
            }
            throw new RuntimeException("Failed to create a BeanCreator for method " + method);
        }

        @Override
        public PropertyMutator createMutator(String name, Field field, Type ofType, Genson genson) {
            for (BeanPropertyFactory factory : this.factories) {
                PropertyMutator mutator = factory.createMutator(name, field, ofType, genson);
                if (mutator == null) continue;
                return mutator;
            }
            throw new RuntimeException("Failed to create a mutator for field " + field);
        }

        @Override
        public PropertyMutator createMutator(String name, Method method, Type ofType, Genson genson) {
            for (BeanPropertyFactory factory : this.factories) {
                PropertyMutator mutator = factory.createMutator(name, method, ofType, genson);
                if (mutator == null) continue;
                return mutator;
            }
            throw new RuntimeException("Failed to create a mutator for method " + method);
        }
    }
}

