/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.annotation.JsonProperty;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public abstract class BeanProperty {
    protected final String name;
    protected final Type type;
    protected final Class<?> declaringClass;
    protected final Class<?> concreteClass;
    protected Annotation[] annotations;
    protected final int modifiers;

    protected BeanProperty(String name, Type type, Class<?> declaringClass, Class<?> concreteClass, Annotation[] annotations, int modifiers) {
        this.name = name;
        this.type = type;
        this.declaringClass = declaringClass;
        this.concreteClass = concreteClass;
        this.annotations = annotations;
        this.modifiers = modifiers;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?> getConcreteClass() {
        return this.concreteClass;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawClass() {
        return TypeUtil.getRawClass(this.type);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String[] aliases() {
        JsonProperty ann = this.getAnnotation(JsonProperty.class);
        return ann != null ? ann.aliases() : new String[]{};
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation ann : this.annotations) {
            if (!annotationClass.isInstance(ann)) continue;
            return (T)((Annotation)annotationClass.cast(ann));
        }
        return null;
    }

    void updateBoth(BeanProperty otherBeanProperty) {
        if (this.annotations.length > 0 || otherBeanProperty.annotations.length > 0) {
            Annotation[] mergedAnnotations = new Annotation[this.annotations.length + otherBeanProperty.annotations.length];
            System.arraycopy(this.annotations, 0, mergedAnnotations, 0, this.annotations.length);
            System.arraycopy(otherBeanProperty.annotations, 0, mergedAnnotations, this.annotations.length, otherBeanProperty.annotations.length);
            if (otherBeanProperty.annotations.length > 0) {
                this.annotations = mergedAnnotations;
            }
            if (this.annotations.length > 0) {
                otherBeanProperty.annotations = mergedAnnotations;
            }
        }
    }

    abstract int priority();

    abstract String signature();
}

