/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.convert.DefaultConverters;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.lang.reflect.Type;

public class ComparableConverter
implements Converter<Comparable> {
    public static final ComparableConverter INSTANCE = new ComparableConverter();

    protected ComparableConverter() {
    }

    @Override
    public Comparable deserialize(ObjectReader reader, Context ctx) throws Exception {
        ValueType type = reader.getValueType();
        if (type == ValueType.STRING) {
            return reader.valueAsString();
        }
        if (type == ValueType.INTEGER || type == ValueType.DOUBLE) {
            return (Comparable)((Object)DefaultConverters.NumberConverter.instance.deserialize(reader, ctx));
        }
        if (reader.getValueType() == ValueType.BOOLEAN) {
            return Boolean.valueOf(reader.valueAsBoolean());
        }
        throw new IllegalStateException();
    }

    @Override
    public void serialize(Comparable object, ObjectWriter writer, Context ctx) throws Exception {
        if (object instanceof String) {
            writer.writeValue(object.toString());
        } else if (object instanceof Number) {
            writer.writeValue((Number)((Object)object));
        } else if (object instanceof Boolean) {
            writer.writeValue((Boolean)object);
        }
    }

    public static class Factory
    implements com.oracle.coherence.io.json.genson.Factory<Converter<Comparable>> {
        public static final Factory INSTANCE = new Factory();

        protected Factory() {
        }

        @Override
        public Converter<Comparable> create(Type type, Genson genson) {
            return TypeUtil.getRawClass(type) == Comparable.class ? INSTANCE : null;
        }
    }
}

