/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json;

import com.oracle.coherence.io.json.JsonObject;
import com.oracle.coherence.io.json.genson.GenericType;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.GensonBuilder;
import com.oracle.coherence.io.json.genson.Modifier;
import com.oracle.coherence.io.json.genson.convert.NullConverterFactory;
import com.oracle.coherence.io.json.genson.datetime.JavaDateTimeBundle;
import com.oracle.coherence.io.json.genson.ext.jackson.JacksonBundle;
import com.oracle.coherence.io.json.genson.ext.jsonb.JsonbBundle;
import com.oracle.coherence.io.json.genson.ext.jsr353.JSR353Bundle;
import com.oracle.coherence.io.json.genson.reflect.EvolvableHandler;
import com.oracle.coherence.io.json.genson.reflect.VisibilityFilter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import com.oracle.coherence.io.json.internal.ClassConverter;
import com.oracle.coherence.io.json.internal.ComparableConverter;
import com.oracle.coherence.io.json.internal.EnumConverter;
import com.oracle.coherence.io.json.internal.GensonServiceBundle;
import com.oracle.coherence.io.json.internal.InetAddressConverter;
import com.oracle.coherence.io.json.internal.InetSocketAddressConverter;
import com.oracle.coherence.io.json.internal.JsonObjectConverter;
import com.oracle.coherence.io.json.internal.MapConverter;
import com.oracle.coherence.io.json.internal.MissingClassConverter;
import com.oracle.coherence.io.json.internal.SerializationSupportConverter;
import com.oracle.coherence.io.json.internal.ThrowableConverter;
import com.oracle.coherence.io.json.internal.VersionableSerializer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Versionable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;

@Named(value="json")
@ApplicationScoped
public class JsonSerializer
implements Serializer,
ClassLoaderAware {
    private static final GenericType<Object> OBJECT_TYPE = GenericType.of(Object.class);
    private static final Class<?>[] JSON_TYPES = new Class[]{String.class, Number.class, Boolean.class};
    public static final String PROP_DEBUG_MODE = "coherence.io.json.debug";
    public static final boolean DEBUG_MODE = Boolean.getBoolean("coherence.io.json.debug");
    protected final Genson f_genson;
    protected final boolean f_fCompatibleMode;
    protected WeakReference<ClassLoader> m_refLoader;

    public JsonSerializer() {
        this(null, null, false);
    }

    public JsonSerializer(boolean compatibleMode) {
        this(null, null, compatibleMode);
    }

    public String getName() {
        return "json";
    }

    public JsonSerializer(ClassLoader loader) {
        this(loader, null, false);
    }

    public JsonSerializer(ClassLoader loader, Modifier<GensonBuilder> builderModifier, boolean compatibleMode) {
        this.f_fCompatibleMode = compatibleMode;
        GensonBuilder builder = new GensonBuilder().withBundle(new JacksonBundle()).withBundle(new JsonbBundle()).withBundle(new JSR353Bundle()).withBundle(new JavaDateTimeBundle()).withBundle(new GensonServiceBundle()).setDefaultType(ValueType.OBJECT, JsonObject.class).setDefaultType(ValueType.INTEGER, Number.class).setDefaultType(ValueType.DOUBLE, Number.class).useClassMetadata(true).useClassMetadataWithStaticType(false).useFields(true, VisibilityFilter.PRIVATE).useMethods(false).useConstructorWithArguments(true).useUnknownPropertyHandler(new EvolvableHandler()).setSkipNull(true).withSerializer(VersionableSerializer.INSTANCE, Versionable.class).withConverter(InetAddressConverter.INSTANCE, InetAddress.class).withConverter(InetAddressConverter.INSTANCE, Inet4Address.class).withConverter(InetAddressConverter.INSTANCE, Inet6Address.class).withConverter(InetSocketAddressConverter.INSTANCE, InetSocketAddress.class).withConverter(JsonObjectConverter.INSTANCE, JsonObject.class);
        if (!this.f_fCompatibleMode) {
            builder.withConverterFactory(MapConverter.Factory.INSTANCE);
        }
        builder.withConverterFactory(ComparableConverter.Factory.INSTANCE).withConverterFactory(ClassConverter.Factory.INSTANCE).withConverterFactory(EnumConverter.Factory.INSTANCE).withConverterFactory(ThrowableConverter.Factory.INSTANCE).withConverterFactory(factory -> factory.find(NullConverterFactory.class).withNext(new SerializationSupportConverter.Factory(this)).withNext(MissingClassConverter.Factory.INSTANCE));
        if (builderModifier != null) {
            builder = builderModifier.apply(builder);
        }
        this.f_genson = builder.create();
        this.setContextClassLoader(loader);
    }

    public ClassLoader getContextClassLoader() {
        WeakReference<ClassLoader> refLoader = this.m_refLoader;
        return refLoader == null ? null : (ClassLoader)refLoader.get();
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        assert (this.m_refLoader == null);
        if (classLoader != null) {
            this.m_refLoader = new WeakReference<ClassLoader>(classLoader);
            this.f_genson.setLoader(classLoader);
        }
    }

    public void serialize(WriteBuffer.BufferOutput bufferOutput, Object oValue) throws IOException {
        GenericType<Object> type = OBJECT_TYPE;
        if (oValue != null) {
            for (Class<?> c : JSON_TYPES) {
                if (!c.isInstance(oValue)) continue;
                type = GenericType.of(oValue.getClass());
            }
        }
        if (DEBUG_MODE) {
            Class<?> cls = oValue == null ? null : oValue.getClass();
            Base.log((String)("-------------------- JSON DEBUG: Serializing -------------------- \nType: " + cls + "\nValue: " + oValue + "\n" + this.f_genson.serialize(oValue) + "\n---------------------------------------------------------------"));
        }
        this.f_genson.serialize(oValue, type, (OutputStream)new WrapperDataOutputStream((DataOutput)bufferOutput));
    }

    public <T> T deserialize(ReadBuffer.BufferInput in, Class<? extends T> clazz) throws IOException {
        if (in.available() == 0) {
            return null;
        }
        WrapperDataInputStream stream = new WrapperDataInputStream((DataInput)in);
        if (DEBUG_MODE) {
            byte[] abData = new byte[stream.available()];
            stream.read(abData);
            try {
                T oValue = this.f_genson.deserialize(new String(abData), clazz);
                Class<?> cls = oValue == null ? null : oValue.getClass();
                Base.log((String)("-------------------- JSON DEBUG: Deserializing -------------------- \nType: " + cls + "\nValue: " + oValue + "\n" + this.f_genson.serialize(oValue) + "\n---------------------------------------------------------------"));
                return oValue;
            }
            catch (Throwable thrown) {
                Base.err((String)("JSON DEBUG: Failed to deserialize " + new String(abData)));
                throw Base.ensureRuntimeException((Throwable)thrown);
            }
        }
        return this.f_genson.deserialize((Reader)new InputStreamReader((InputStream)stream), clazz);
    }

    public Genson underlying() {
        return this.f_genson;
    }

    public static class Factory
    implements SerializerFactory {
        public Serializer createSerializer(ClassLoader loader) {
            return new JsonSerializer(loader);
        }
    }
}

