/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;

public class CoherenceCacheEntryEventFilteringIterator<K, V>
implements Iterator<CacheEntryEvent<K, V>> {
    private Iterator<CacheEntryEvent<K, V>> m_iterator;
    private CacheEntryEventFilter<? super K, ? super V> m_filter;
    private CacheEntryEvent<K, V> m_entryNext;

    public CoherenceCacheEntryEventFilteringIterator(Iterator<CacheEntryEvent<K, V>> iterator, CacheEntryEventFilter<? super K, ? super V> filter) {
        this.m_iterator = iterator;
        this.m_filter = filter;
        this.m_entryNext = null;
    }

    private void fetch() {
        while (this.m_entryNext == null && this.m_iterator.hasNext()) {
            CacheEntryEvent<K, V> entry = this.m_iterator.next();
            if (!this.m_filter.evaluate(entry)) continue;
            this.m_entryNext = entry;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.m_entryNext == null) {
            this.fetch();
        }
        return this.m_entryNext != null;
    }

    @Override
    public CacheEntryEvent<K, V> next() {
        if (this.hasNext()) {
            CacheEntryEvent<K, V> entry = this.m_entryNext;
            this.m_entryNext = null;
            return entry;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.m_iterator.remove();
        this.m_entryNext = null;
    }
}

