/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache;

import com.tangosol.coherence.jcache.CoherenceBasedCache;
import com.tangosol.coherence.jcache.CoherenceBasedCacheManager;
import com.tangosol.coherence.jcache.CoherenceBasedConfiguration;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.net.NamedCache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.management.CacheMXBean;

public abstract class AbstractCoherenceBasedCache<K, V, C extends CoherenceBasedConfiguration<K, V>>
implements CoherenceBasedCache<K, V> {
    protected CoherenceBasedCacheManager m_manager;
    protected String m_sJCacheName;
    protected NamedCache m_namedCache;
    protected C m_configuration;
    private volatile boolean m_fClosed;

    public AbstractCoherenceBasedCache(CoherenceBasedCacheManager manager, String sJCacheName, C configuration) {
        this.m_manager = manager;
        this.m_sJCacheName = sJCacheName;
        this.m_configuration = configuration;
        this.m_fClosed = false;
    }

    public void close() {
        if (!this.isClosed()) {
            this.m_fClosed = true;
            this.onBeforeClosing();
            this.m_manager.releaseCache(this.m_sJCacheName);
        }
    }

    public <T extends Configuration<K, V>> T getConfiguration(Class<T> clz) {
        if (clz.isInstance(this.m_configuration)) {
            return (T)((Configuration)clz.cast(this.m_configuration));
        }
        throw new IllegalArgumentException("Unsupported type in getConfiguration(" + clz.getName() + ")");
    }

    public String getName() {
        return this.m_sJCacheName;
    }

    public CacheManager getCacheManager() {
        return this.m_manager;
    }

    public boolean isClosed() {
        return this.m_fClosed;
    }

    public <T> T unwrap(Class<T> clz) {
        if (clz.isAssignableFrom(this.getClass())) {
            return clz.cast(this);
        }
        if (clz.isAssignableFrom(NamedCache.class)) {
            return (T)this.m_namedCache;
        }
        throw new IllegalArgumentException("Class " + this.getClass().getName() + " can't be unwrapped to: " + clz.getName());
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Operation not permitted as the Cache is closed");
        }
    }

    public abstract void onBeforeClosing();

    protected ClassLoader getClassLoader() {
        return this.m_manager.getClassLoader();
    }

    public abstract CacheMXBean getMBean();

    public abstract JCacheStatistics getStatistics();

    public abstract void setManagementEnabled(boolean var1);

    public abstract void setStatisticsEnabled(boolean var1);

    public abstract boolean isStatisticsEnabled();

    @Override
    public abstract JCacheIdentifier getIdentifier();
}

