/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.passthroughcache;

import com.tangosol.util.MapEvent;
import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;

public class PassThroughCacheEntryEvent<K, V>
extends CacheEntryEvent<K, V> {
    private MapEvent m_event;

    public PassThroughCacheEntryEvent(Cache<K, V> cache, EventType type, MapEvent event) {
        super(cache, type);
        this.m_event = event;
    }

    public K getKey() {
        return (K)this.m_event.getKey();
    }

    public V getValue() {
        return (V)this.m_event.getNewValue();
    }

    public <T> T unwrap(Class<T> clz) {
        if (clz != null && clz.isInstance(this.m_event)) {
            return (T)this.m_event;
        }
        throw new IllegalArgumentException("Unsupported unwrap(" + String.valueOf(clz) + ")");
    }

    public boolean isOldValueAvailable() {
        return this.m_event.getOldValue() != null;
    }

    public V getOldValue() {
        return (V)this.m_event.getOldValue();
    }

    public static <K, V> PassThroughCacheEntryEvent<K, V> from(MapEvent event) {
        return new PassThroughCacheEntryEvent<K, V>(null, switch (event.getId()) {
            case 1 -> EventType.CREATED;
            case 2 -> EventType.UPDATED;
            case 3 -> EventType.REMOVED;
            default -> null;
        }, event);
    }
}

