/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.CoherenceEntryProcessorResult;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractEntryProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;

public class InvokeProcessor<K, V, T>
extends AbstractEntryProcessor {
    private EntryProcessor<K, V, T> m_processor;
    private Object[] m_varargs;

    public InvokeProcessor() {
    }

    public InvokeProcessor(JCacheIdentifier id, EntryProcessor<K, V, T> proc, Object ... args) {
        super(id);
        this.m_processor = proc;
        this.m_varargs = args.length == 0 ? null : args;
    }

    public Object process(InvocableMap.Entry entry) throws CacheException {
        CoherenceEntryProcessorResult<Object> result = null;
        try {
            long ldtStart = Helper.getCurrentTimeMillis();
            BinaryEntry binEntry = entry instanceof BinaryEntry ? (BinaryEntry)entry : null;
            JCacheContext jcacheCtx = BinaryEntryHelper.getContext(this.m_cacheId, binEntry);
            JCacheStatistics stats = jcacheCtx.getStatistics();
            BackingMapManagerContext ctx = binEntry != null ? binEntry.getContext() : null;
            EntryProcessorEntry epe = new EntryProcessorEntry(entry, jcacheCtx.getExpiryPolicy(), ldtStart);
            JCacheEntryMetaInf valueMetaInf = null;
            Object oResult = this.m_varargs == null ? this.m_processor.process(epe, new Object[0]) : this.m_processor.process(epe, this.m_varargs);
            result = oResult == null ? null : new CoherenceEntryProcessorResult<Object>(oResult);
            Binary binValue = epe.getBinaryValueNoCacheLoading();
            valueMetaInf = BinaryEntryHelper.getValueMetaInf(binValue, ctx);
            if (entry.isPresent()) {
                stats.registerHits(1, ldtStart);
            } else {
                stats.registerMisses(1, ldtStart);
            }
            switch (epe.m_operation) {
                case NONE: {
                    break;
                }
                case ACCESS: {
                    boolean fExpired;
                    boolean bl = fExpired = binValue == null || valueMetaInf != null && valueMetaInf.isExpiredAt(ldtStart);
                    if (fExpired) {
                        BinaryEntryHelper.expireEntry(binEntry);
                        return null;
                    }
                    valueMetaInf.accessed(ldtStart, jcacheCtx.getExpiryPolicy());
                    binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(binValue, valueMetaInf, ctx);
                    binValue = BinaryEntryHelper.jcacheSyntheticUpdateEntry(binValue, ctx);
                    binEntry.updateBinaryValue(binValue);
                    break;
                }
                case CREATE: {
                    if (valueMetaInf == null) {
                        valueMetaInf = new JCacheEntryMetaInf(ldtStart, jcacheCtx.getExpiryPolicy());
                    }
                    if (valueMetaInf.isExpiredAt(ldtStart)) break;
                    binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(binValue, valueMetaInf, ctx);
                    binEntry.updateBinaryValue(binValue);
                    stats.registerPuts(1L, ldtStart);
                    break;
                }
                case UPDATE: {
                    binEntry.updateBinaryValue(binValue);
                    stats.registerPuts(1L, ldtStart);
                    break;
                }
                case REMOVE: {
                    binEntry.remove(false);
                    stats.registerRemoves(1L, ldtStart);
                    break;
                }
            }
        }
        catch (Exception e) {
            result = new CoherenceEntryProcessorResult<Object>((Object)e);
        }
        return result;
    }

    public Map processAll(Set setEntries) {
        LiteMap mapResults = new LiteMap();
        Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
        long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
        for (InvocableMap.Entry entry : setEntries) {
            Object result = this.process(entry);
            if (result != null) {
                mapResults.put(entry.getKey(), result);
            }
            if (ctxGuard == null) continue;
            ctxGuard.heartbeat(cMillis);
        }
        return mapResults;
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        super.readExternal(dataInput);
        this.m_processor = (EntryProcessor)ExternalizableHelper.readObject((DataInput)dataInput);
        ArrayList varargs = new ArrayList(10);
        ExternalizableHelper.readCollection((DataInput)dataInput, varargs, (ClassLoader)InvokeProcessor.getContextClassLoader());
        this.m_varargs = varargs.toArray();
        if (this.m_varargs.length == 0) {
            this.m_varargs = null;
        }
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        super.writeExternal(dataOutput);
        ExternalizableHelper.writeObject((DataOutput)dataOutput, this.m_processor);
        List<Object> l = this.m_varargs == null ? new ArrayList() : Arrays.asList(this.m_varargs);
        ExternalizableHelper.writeCollection((DataOutput)dataOutput, l);
    }

    @Override
    public void readExternal(PofReader pofReader) throws IOException {
        super.readExternal(pofReader);
        this.m_processor = (EntryProcessor)pofReader.readObject(1);
        this.m_varargs = pofReader.readObjectArray(2, new Object[20]);
    }

    @Override
    public void writeExternal(PofWriter pofWriter) throws IOException {
        super.writeExternal(pofWriter);
        pofWriter.writeObject(1, this.m_processor);
        pofWriter.writeObjectArray(2, this.m_varargs);
    }

    private static enum MutableEntryOperation {
        NONE,
        ACCESS,
        CREATE,
        REMOVE,
        UPDATE;

    }

    private static class EntryProcessorEntry<K, V>
    implements MutableEntry<K, V> {
        private V m_value;
        private Binary m_binValue;
        private MutableEntryOperation m_operation;
        private long m_ldtNow;
        private final BinaryEntry m_binEntry;
        private final BackingMapManagerContext m_ctx;
        private JCacheEntryMetaInf m_valueMetaInf;
        private final ExpiryPolicy f_expiryPolicy;

        public EntryProcessorEntry(InvocableMap.Entry entry, ExpiryPolicy expiryPolicy, long ldtNow) {
            this.m_binEntry = entry instanceof BinaryEntry ? (BinaryEntry)entry : null;
            this.f_expiryPolicy = expiryPolicy;
            this.m_ldtNow = ldtNow;
            this.m_ctx = this.m_binEntry == null ? null : this.m_binEntry.getContext();
            this.m_valueMetaInf = this.m_binEntry == null ? null : BinaryEntryHelper.getValueMetaInf(this.m_binEntry);
            this.m_binValue = null;
            this.m_value = null;
            this.m_operation = MutableEntryOperation.NONE;
        }

        public K getKey() {
            return (K)this.m_binEntry.getKey();
        }

        public V getValue() {
            Binary binValueResult = this.getBinaryValueNoCacheLoading();
            if (binValueResult == null) {
                if (this.m_binEntry != null && this.m_binEntry.isPresent()) {
                    this.m_binEntry.updateBinaryValue(null);
                }
                if ((binValueResult = this.m_binEntry.getBinaryValue()) != null) {
                    this.m_binValue = binValueResult;
                    this.m_operation = MutableEntryOperation.CREATE;
                    this.m_valueMetaInf = (JCacheEntryMetaInf)this.m_ctx.getInternalValueDecoration((Object)binValueResult, 14);
                    if (this.m_valueMetaInf == null) {
                        this.m_valueMetaInf = new JCacheEntryMetaInf(this.m_ldtNow, this.f_expiryPolicy);
                        this.m_binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(this.m_binValue, this.m_valueMetaInf, this.m_ctx);
                    }
                } else {
                    return null;
                }
            }
            if (this.m_operation == MutableEntryOperation.NONE) {
                this.m_operation = MutableEntryOperation.ACCESS;
            }
            return (V)(binValueResult == null ? null : this.m_ctx.getValueFromInternalConverter().convert((Object)binValueResult));
        }

        public boolean exists() {
            switch (this.m_operation) {
                case NONE: 
                case ACCESS: {
                    if (this.m_binEntry == null || !this.m_binEntry.isPresent()) {
                        return false;
                    }
                }
                case CREATE: 
                case UPDATE: {
                    return !this.isExpiredAt();
                }
                case REMOVE: {
                    return false;
                }
            }
            throw new IllegalStateException("missing case in exists");
        }

        public void remove() {
            this.m_operation = this.m_operation == MutableEntryOperation.CREATE ? MutableEntryOperation.NONE : MutableEntryOperation.REMOVE;
            this.m_binValue = null;
            this.m_value = null;
            this.m_valueMetaInf = null;
        }

        public void setValue(V oValue) {
            if (oValue == null) {
                throw new NullPointerException();
            }
            if (this.m_operation != MutableEntryOperation.CREATE && this.exists()) {
                this.m_operation = MutableEntryOperation.UPDATE;
                this.m_valueMetaInf = this.m_binValue != null ? (JCacheEntryMetaInf)this.m_ctx.getInternalValueDecoration((Object)this.m_binValue, 14) : BinaryEntryHelper.getValueMetaInf(this.m_binEntry);
                this.m_value = oValue;
                this.m_binValue = (Binary)this.m_ctx.getValueToInternalConverter().convert(oValue);
                this.m_valueMetaInf.modified(this.m_ldtNow, this.f_expiryPolicy);
                this.m_binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(this.m_binValue, this.m_valueMetaInf, this.m_ctx);
            } else {
                Binary binValue = (Binary)this.m_ctx.getValueToInternalConverter().convert(oValue);
                JCacheEntryMetaInf binValueMetaInf = new JCacheEntryMetaInf(this.m_ldtNow, this.f_expiryPolicy);
                if (!binValueMetaInf.isExpiredAt(this.m_ldtNow)) {
                    this.m_binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(binValue, binValueMetaInf, this.m_ctx);
                    this.m_valueMetaInf = binValueMetaInf;
                    this.m_value = oValue;
                    this.m_operation = MutableEntryOperation.CREATE;
                }
            }
        }

        public <T> T unwrap(Class<T> clz) {
            throw new IllegalArgumentException("Can't unwrap an EntryProcessor Entry");
        }

        private Binary getBinaryValueNoCacheLoading() {
            if (this.m_operation == MutableEntryOperation.REMOVE) {
                return null;
            }
            if (this.m_operation == MutableEntryOperation.CREATE || this.m_operation == MutableEntryOperation.UPDATE) {
                return BinaryEntryHelper.isExpired(this.m_ctx, this.m_binValue, this.m_valueMetaInf, this.m_ldtNow) ? null : this.m_binValue;
            }
            Binary binValue = this.m_binEntry != null && this.m_binEntry.isPresent() ? this.m_binEntry.getBinaryValue() : null;
            return binValue != null && !BinaryEntryHelper.isExpired(this.m_ctx, binValue, this.m_valueMetaInf, this.m_ldtNow) ? binValue : null;
        }

        private boolean isExpiredAt() {
            return this.m_binValue != null ? BinaryEntryHelper.isExpired(this.m_ctx, this.m_binValue, this.m_valueMetaInf, this.m_ldtNow) : BinaryEntryHelper.isExpired(this.m_ctx, this.getBinaryValueNoCacheLoading(), this.m_valueMetaInf, this.m_ldtNow);
        }
    }
}

