/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.RefreshableSslContext;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import com.tangosol.net.SocketProviderFactory;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.netty.NettySslContextChannelCredentials;
import io.netty.handler.ssl.SslContext;

public class CredentialsHelper {
    private CredentialsHelper() {
    }

    public static ChannelCredentials createChannelCredentials(SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            String sSocketId;
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId = socketBuilder.getId());
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return InsecureChannelCredentials.create();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContextDependencies sslContextDependencies = dependencies.getSSLContextDependencies();
                RefreshableSslContext sslContext = new RefreshableSslContext(sslContextDependencies, false);
                return NettySslContextChannelCredentials.create((SslContext)sslContext);
            }
        }
        return InsecureChannelCredentials.create();
    }
}

