/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.GrpcChannelConfigurer;
import com.oracle.coherence.client.GrpcRemoteCacheService;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.grpc.CredentialsHelper;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteNameService;
import com.tangosol.coherence.config.builder.FactoryBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.grpc.RemoteGrpcCacheServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteNameServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.LegacyXmlRemoteNameServiceHelper;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.grpc.GrpcChannelDependencies;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.EquivalentAddressGroup;
import io.grpc.Grpc;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class GrpcChannelFactory
extends NameResolverProvider {
    public static final String RESOLVER_SCHEME = "coherence";
    private final Map<String, GrpcServiceInfo> m_mapServiceInfo = new ConcurrentHashMap<String, GrpcServiceInfo>();

    private GrpcChannelFactory() {
        NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)this);
    }

    public static GrpcChannelFactory singleton() {
        return Instance.Singleton.getFactory();
    }

    public Channel getChannel(GrpcRemoteCacheService service) {
        RemoteGrpcCacheServiceDependencies depsService = service.getDependencies();
        GrpcChannelDependencies depsChannel = depsService.getChannelDependencies();
        ManagedChannelBuilder<?> builder = depsChannel.getChannelProvider().orElse(this.createManagedChannelBuilder(service));
        return builder.build();
    }

    private ManagedChannelBuilder<?> createManagedChannelBuilder(GrpcRemoteCacheService service) {
        RemoteGrpcCacheServiceDependencies depsService = service.getDependencies();
        OperationalContext ctx = (OperationalContext)service.getCluster();
        String sService = service.getServiceName();
        String sKey = GrpcServiceInfo.createKey(service);
        String sRemoteService = depsService.getRemoteServiceName();
        String sRemoteCluster = depsService.getRemoteClusterName();
        GrpcChannelDependencies depsChannel = depsService.getChannelDependencies();
        this.m_mapServiceInfo.put(sKey, new GrpcServiceInfo(ctx, sService, sRemoteService, sRemoteCluster, depsChannel));
        String sTarget = depsChannel.getTarget();
        if (sTarget == null) {
            sTarget = GrpcServiceInfo.createTargetURI(service);
        }
        SocketProviderBuilder builder = depsChannel.getSocketProviderBuilder();
        ChannelCredentials credentials = CredentialsHelper.createChannelCredentials((String)sService, (SocketProviderBuilder)builder);
        ManagedChannelBuilder channelBuilder = Grpc.newChannelBuilder((String)sTarget, (ChannelCredentials)credentials);
        depsChannel.getAuthorityOverride().ifPresent(arg_0 -> ((ManagedChannelBuilder)channelBuilder).overrideAuthority(arg_0));
        depsChannel.getConfigurer().filter(GrpcChannelConfigurer.class::isInstance).map(GrpcChannelConfigurer.class::cast).ifPresent(c -> c.apply(channelBuilder));
        channelBuilder.defaultLoadBalancingPolicy(depsChannel.getDefaultLoadBalancingPolicy());
        channelBuilder.userAgent("Coherence Java Client");
        return channelBuilder;
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        String sKey = GrpcServiceInfo.parseServiceInfoKey(targetUri);
        GrpcServiceInfo serviceInfo = this.m_mapServiceInfo.get(sKey);
        GrpcChannelDependencies dependencies = serviceInfo.getDependencies();
        return new AddressProviderNameResolver(dependencies, serviceInfo, args);
    }

    public String getDefaultScheme() {
        return RESOLVER_SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 0;
    }

    private static enum Instance {
        Singleton(new GrpcChannelFactory());

        private final GrpcChannelFactory m_factory;

        private Instance(GrpcChannelFactory factory) {
            this.m_factory = factory;
        }

        public GrpcChannelFactory getFactory() {
            return this.m_factory;
        }
    }

    public static class GrpcServiceInfo {
        public static final String KEY_SEPARATOR = "$";
        private final OperationalContext m_operationalContext;
        private final String m_sService;
        private final String m_sRemoteService;
        private final String m_sRemoteCluster;
        private final GrpcChannelDependencies m_dependencies;

        public GrpcServiceInfo(OperationalContext ctx, String sService, String sRemoteService, String sRemoteCluster, GrpcChannelDependencies dependencies) {
            this.m_operationalContext = ctx;
            this.m_sService = sService;
            this.m_sRemoteService = sRemoteService;
            this.m_sRemoteCluster = sRemoteCluster;
            this.m_dependencies = dependencies;
        }

        public static String createKey(GrpcRemoteCacheService service) {
            String sService = service.getServiceName();
            String sScope = service.getScopeName();
            if (sScope == null) {
                return sService + KEY_SEPARATOR;
            }
            return sService + KEY_SEPARATOR + sScope;
        }

        public static String parseServiceInfoKey(URI uri) {
            String sService = uri.getAuthority();
            String sScope = uri.getQuery();
            if (sScope != null && !sScope.isEmpty() && sScope.charAt(0) == '/') {
                sScope = sService.substring(1);
            }
            if (sScope == null) {
                return sService + KEY_SEPARATOR;
            }
            return sService + KEY_SEPARATOR + sScope;
        }

        public static String createTargetURI(GrpcRemoteCacheService service) {
            String sService = service.getServiceName();
            String sScope = service.getScopeName();
            if (sScope == null) {
                return "coherence://" + sService;
            }
            return "coherence://" + sService + "?" + sScope;
        }

        public OperationalContext getOperationalContext() {
            return this.m_operationalContext;
        }

        public String getService() {
            return this.m_sService;
        }

        public String getRemoteService() {
            if (this.m_sRemoteService == null || this.m_sRemoteService.isBlank()) {
                return "$GRPC:GrpcProxy";
            }
            return this.m_sRemoteService;
        }

        public String getRemoteCluster() {
            return this.m_sRemoteCluster;
        }

        public GrpcChannelDependencies getDependencies() {
            return this.m_dependencies;
        }
    }

    public static class AddressProviderNameResolver
    extends NameResolver {
        private final GrpcServiceInfo m_serviceInfo;
        private final NameResolver.Args m_nameResolverArgs;
        private String m_sAuthority;
        private final SocketAddressProvider m_addressProvider;
        private final boolean m_fNameServiceAddressProvider;
        private volatile boolean m_fResolving;
        private volatile boolean m_fShutdown;
        private Executor m_executor;
        private final SharedResourceHolder.Resource<Executor> m_executorResource;
        private NameResolver.Listener2 m_listener;

        public AddressProviderNameResolver(GrpcChannelDependencies deps, GrpcServiceInfo serviceInfo, NameResolver.Args args) {
            AddressProviderFactory factory;
            this.m_fNameServiceAddressProvider = deps.isNameServiceAddressProvider();
            this.m_executorResource = GrpcUtil.SHARED_CHANNEL_EXECUTOR;
            this.m_serviceInfo = serviceInfo;
            this.m_nameResolverArgs = args;
            Object bldr = deps.getRemoteAddressProviderBuilder();
            if (bldr == null && (factory = (AddressProviderFactory)serviceInfo.getOperationalContext().getAddressProviderMap().get("cluster-discovery")) != null) {
                bldr = factory instanceof ParameterizedBuilder ? (ParameterizedBuilder)factory : new FactoryBasedAddressProviderBuilder(factory);
            }
            ClassLoader loader = Classes.getContextClassLoader();
            this.m_addressProvider = (SocketAddressProvider)bldr.realize((ParameterResolver)new NullParameterResolver(), loader, null);
            new Resolve(this, serviceInfo).run();
        }

        public String getServiceAuthority() {
            return this.m_sAuthority;
        }

        public void start(NameResolver.Listener2 listener) {
            this.m_listener = Objects.requireNonNull(listener);
            this.m_executor = (Executor)SharedResourceHolder.get(this.m_executorResource);
            this.resolve();
        }

        public void refresh() {
            if (this.m_listener != null) {
                this.resolve();
            }
        }

        public void shutdown() {
            if (this.m_fShutdown) {
                return;
            }
            this.m_fShutdown = true;
            if (this.m_executor != null) {
                this.m_executor = (Executor)SharedResourceHolder.release(this.m_executorResource, (Object)this.m_executor);
            }
        }

        protected NameResolver.Args getNameResolverArgs() {
            return this.m_nameResolverArgs;
        }

        protected SocketAddressProvider getSocketAddressProvider() {
            return this.m_addressProvider;
        }

        protected boolean isNameServiceAddressProvider() {
            return this.m_fNameServiceAddressProvider;
        }

        protected void setAuthority(String sAuthority) {
            this.m_sAuthority = sAuthority;
        }

        private void resolve() {
            if (this.m_fResolving || this.m_fShutdown) {
                return;
            }
            this.m_fResolving = true;
            this.m_executor.execute(new Resolve(this, this.m_serviceInfo, this.m_listener));
        }
    }

    protected static class Resolve
    implements Runnable {
        private final AddressProviderNameResolver m_addressProviderNameResolver;
        private final NameResolver.Listener2 m_listener;
        private final GrpcServiceInfo m_serviceInfo;

        protected Resolve(AddressProviderNameResolver addressProviderNameResolver, GrpcServiceInfo serviceInfo) {
            this(addressProviderNameResolver, serviceInfo, null);
        }

        protected Resolve(AddressProviderNameResolver addressProviderNameResolver, GrpcServiceInfo serviceInfo, NameResolver.Listener2 listener) {
            this.m_addressProviderNameResolver = addressProviderNameResolver;
            this.m_serviceInfo = serviceInfo;
            this.m_listener = listener;
        }

        @Override
        public void run() {
            NameResolver.ResolutionResult result;
            List<SocketAddress> list;
            List<SocketAddress> list2 = list = this.m_addressProviderNameResolver.isNameServiceAddressProvider() ? this.lookupAddresses() : this.resolveAddresses();
            if (list.isEmpty()) {
                NameResolver.ConfigOrError error = NameResolver.ConfigOrError.fromError((Status)Status.FAILED_PRECONDITION.withDescription("Failed to resolve any gRPC proxy addresses"));
                result = NameResolver.ResolutionResult.newBuilder().setServiceConfig(error).setAttributes(Attributes.EMPTY).build();
            } else {
                try {
                    ProxyDetector proxyDetector;
                    NameResolver.Args args = this.m_addressProviderNameResolver.getNameResolverArgs();
                    ProxyDetector proxyDetector2 = proxyDetector = args == null ? null : args.getProxyDetector();
                    if (proxyDetector != null) {
                        ArrayList<SocketAddress> proxiedAddresses = new ArrayList<SocketAddress>();
                        for (SocketAddress socketAddress : list) {
                            proxiedAddresses.add(Objects.requireNonNullElse(proxyDetector.proxyFor(socketAddress), socketAddress));
                        }
                        list = proxiedAddresses;
                    }
                    result = NameResolver.ResolutionResult.newBuilder().setAddresses(Collections.singletonList(new EquivalentAddressGroup(list))).setAttributes(Attributes.EMPTY).build();
                }
                catch (IOException e) {
                    Logger.err((Throwable)e);
                    NameResolver.ConfigOrError error = NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription(e.getMessage()));
                    result = NameResolver.ResolutionResult.newBuilder().setServiceConfig(error).setAttributes(Attributes.EMPTY).build();
                }
            }
            if (this.m_listener != null) {
                this.m_listener.onResult(result);
            }
        }

        protected List<SocketAddress> resolveAddresses() {
            SocketAddressProvider addressProvider = this.m_addressProviderNameResolver.getSocketAddressProvider();
            ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
            SocketAddress address = addressProvider.getNextAddress();
            boolean fFirst = true;
            while (address != null) {
                if (address instanceof InetSocketAddress32) {
                    address = new InetSocketAddress(((InetSocketAddress32)address).getAddress(), ((InetSocketAddress32)address).getPort());
                }
                if (address instanceof InetSocketAddress) {
                    if (fFirst) {
                        this.updateAuthority((InetSocketAddress)address);
                        fFirst = false;
                    }
                    list.add(address);
                }
                address = addressProvider.getNextAddress();
            }
            return list;
        }

        private void updateAuthority(InetSocketAddress address) {
            String sAuthority = GrpcUtil.authorityFromHostAndPort((String)address.getHostString(), (int)address.getPort());
            this.m_addressProviderNameResolver.setAuthority(sAuthority);
        }

        protected List<SocketAddress> lookupAddresses() {
            SocketAddressProvider addressProvider = this.m_addressProviderNameResolver.getSocketAddressProvider();
            RemoteNameService serviceNS = new RemoteNameService();
            OperationalContext context = this.m_serviceInfo.getOperationalContext();
            serviceNS.setOperationalContext(context);
            serviceNS.setContextClassLoader(Classes.getContextClassLoader());
            serviceNS.setServiceName(this.m_serviceInfo.getService() + ":RemoteNameService");
            DefaultRemoteNameServiceDependencies nameServiceDeps = LegacyXmlRemoteNameServiceHelper.fromXml((XmlElement)CacheFactory.getServiceConfig((String)"RemoteNameService"), (DefaultRemoteNameServiceDependencies)new DefaultRemoteNameServiceDependencies(), (OperationalContext)context, (ClassLoader)Classes.getContextClassLoader());
            DefaultTcpInitiatorDependencies depsNsTcp = new DefaultTcpInitiatorDependencies();
            depsNsTcp.setRemoteSocketAddressProviderBuilder((resolver, loader, listParameters) -> addressProvider);
            depsNsTcp.setSocketProviderBuilder(new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER, false));
            String sServiceRemote = this.m_serviceInfo.getRemoteService();
            String sCluster = this.m_serviceInfo.getRemoteCluster();
            if (sCluster == null || sCluster.isEmpty()) {
                sCluster = context.getLocalMember().getClusterName();
            }
            nameServiceDeps.setInitiatorDependencies((InitiatorDependencies)depsNsTcp);
            nameServiceDeps.setRemoteClusterName(sCluster);
            nameServiceDeps.setRemoteServiceName("NameService");
            serviceNS.setDependencies((ServiceDependencies)nameServiceDeps);
            try {
                serviceNS.start();
                Object[] aoResult = (Object[])serviceNS.lookup(sServiceRemote);
                if (aoResult == null) {
                    throw new ConnectionException("Unable to locate ProxyService '" + sServiceRemote + "' within cluster '" + this.m_serviceInfo.getRemoteCluster() + "'");
                }
                ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
                for (int i = 0; i < aoResult.length; i += 2) {
                    list.add(new InetSocketAddress((String)aoResult[i], (int)((Integer)aoResult[i + 1])));
                }
                list.stream().findAny().ifPresent(address -> this.updateAuthority((InetSocketAddress)address));
                if (list.isEmpty()) {
                    throw new ConnectionException("Unable to locate any addresses in cluster '" + sCluster + "' while looking for its ProxyService '" + sServiceRemote + "'");
                }
                ArrayList<SocketAddress> arrayList = list;
                return arrayList;
            }
            catch (Exception ex) {
                throw new ConnectionException("Unable to locate cluster '" + sCluster + "' while looking for its ProxyService '" + sServiceRemote + "'", (Throwable)ex);
            }
            finally {
                serviceNS.stop();
            }
        }
    }
}

