/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.AsyncNamedCacheClient;
import com.oracle.coherence.client.DeactivationListener;
import com.oracle.coherence.client.GrpcCacheLifecycleEventDispatcher;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.SimpleDaemonPoolExecutor;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.Serializer;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Service;
import com.tangosol.net.Session;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.internal.Registry;
import com.tangosol.net.events.internal.SessionEventDispatcher;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.MapEvent;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class GrpcRemoteSession
implements Session {
    private static final AtomicInteger f_cPool = new AtomicInteger();
    private final String f_sScopeName;
    private final String f_sName;
    private final Channel f_channel;
    private final Serializer f_serializer;
    private final String f_sSerializerFormat;
    private final Map<String, AsyncNamedCacheClient<?, ?>> f_mapCaches;
    private final ClientDeactivationListener f_deactivationListener;
    private final TruncateListener f_truncateListener;
    private final SessionEventDispatcher f_eventDispatcher;
    protected final ClientInterceptor f_tracingInterceptor;
    protected boolean m_fActivated;
    protected boolean m_fClosed;
    protected final Executor f_executor;
    protected final ResourceRegistry f_registry;

    protected GrpcRemoteSession(Channel channel, String sName, String sScopeName, Serializer serializer, String sFormat, ClientInterceptor tracingInterceptor, Iterable<? extends EventInterceptor<?>> interceptors) {
        this.f_channel = Objects.requireNonNull(channel);
        this.f_sName = sName == null ? "" : sName;
        this.f_sScopeName = sScopeName == null ? "" : sScopeName;
        this.f_serializer = Objects.requireNonNull(serializer);
        this.f_sSerializerFormat = Objects.requireNonNull(sFormat);
        this.f_tracingInterceptor = tracingInterceptor;
        this.f_mapCaches = new ConcurrentHashMap();
        this.f_deactivationListener = new ClientDeactivationListener();
        this.f_truncateListener = new TruncateListener();
        String sPoolName = "Grpc-Daemon-Pool-" + f_cPool.getAndIncrement();
        SimpleDaemonPoolExecutor pool = new SimpleDaemonPoolExecutor(sPoolName);
        pool.start();
        this.f_executor = pool;
        Registry eventRegistry = new Registry();
        this.f_registry = new SimpleResourceRegistry();
        this.f_registry.registerResource(InterceptorRegistry.class, (Object)eventRegistry);
        this.f_registry.registerResource(EventDispatcherRegistry.class, (Object)eventRegistry);
        this.f_eventDispatcher = new SessionEventDispatcher((Session)this);
        eventRegistry.registerEventDispatcher((EventDispatcher)this.f_eventDispatcher);
        if (interceptors != null) {
            for (EventInterceptor<?> interceptor : interceptors) {
                eventRegistry.registerEventInterceptor(interceptor, RegistrationBehavior.FAIL);
            }
        }
    }

    public synchronized void activate() {
        if (this.m_fActivated) {
            return;
        }
        this.f_eventDispatcher.dispatchStarting();
        this.m_fActivated = true;
        this.f_eventDispatcher.dispatchStarted();
    }

    public boolean isActive() {
        return this.m_fActivated && !this.isClosed();
    }

    public String getScopeName() {
        return this.f_sScopeName;
    }

    public String getName() {
        return this.f_sName;
    }

    public String scope() {
        return this.f_sScopeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcRemoteSession that = (GrpcRemoteSession)o;
        return Objects.equals(this.f_sScopeName, that.f_sScopeName) && Objects.equals(this.f_channel, that.f_channel) && Objects.equals(this.f_serializer, that.f_serializer) && Objects.equals(this.f_sSerializerFormat, that.f_sSerializerFormat);
    }

    public int hashCode() {
        return Objects.hash(this.f_sScopeName, this.f_channel, this.f_serializer, this.f_sSerializerFormat);
    }

    public String toString() {
        return "RemoteSession{scope: \"" + this.f_sScopeName + "\", serializerFormat \"" + this.f_sSerializerFormat + "\", serializer \"" + this.f_serializer + "\", closed: " + this.m_fClosed + "}";
    }

    public <K, V> NamedMap<K, V> getMap(String sName, NamedMap.Option ... options) {
        return this.getCache(sName, options);
    }

    public <K, V> NamedCache<K, V> getCache(String cacheName, NamedMap.Option ... options) {
        if (this.m_fClosed) {
            throw new IllegalStateException("this session has been closed");
        }
        return this.getAsyncCache(cacheName, options).getNamedCache();
    }

    public <V> NamedTopic<V> getTopic(String sName, NamedCollection.Option ... options) {
        throw new UnsupportedOperationException();
    }

    public synchronized void close() {
        Logger.info((String)("Closing Session " + this.getName()));
        this.f_eventDispatcher.dispatchStopping();
        this.m_fActivated = false;
        this.m_fClosed = true;
        for (AsyncNamedCacheClient<?, ?> client : this.f_mapCaches.values()) {
            client.removeDeactivationListener(this.f_deactivationListener);
            try {
                client.release();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.f_mapCaches.clear();
        this.f_registry.dispose();
        this.f_eventDispatcher.dispatchStopped();
        Logger.info((String)("Closed Session " + this.getName()));
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_registry;
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return (InterceptorRegistry)this.getResourceRegistry().getResource(InterceptorRegistry.class);
    }

    public boolean isCacheActive(String sCacheName, ClassLoader loader) {
        AsyncNamedCacheClient<?, ?> cache = this.f_mapCaches.get(sCacheName);
        return cache != null && cache.isActiveInternal();
    }

    public boolean isMapActive(String sMapName, ClassLoader loader) {
        return this.isCacheActive(sMapName, loader);
    }

    public boolean isTopicActive(String sTopicName, ClassLoader loader) {
        return false;
    }

    public Service getService(String sServiceName) {
        return null;
    }

    public Set<String> getCacheNames() {
        return this.f_mapCaches.entrySet().stream().filter(e -> ((AsyncNamedCacheClient)e.getValue()).getNamedCacheClient().isActive()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean isClosed() {
        return this.m_fClosed;
    }

    protected Channel getChannel() {
        return this.f_channel;
    }

    public Serializer getSerializer() {
        return this.f_serializer;
    }

    public String getSerializerFormat() {
        return this.f_sSerializerFormat;
    }

    public synchronized <K, V> AsyncNamedCacheClient<K, V> getAsyncCache(String sCacheName, NamedMap.Option ... options) {
        AsyncNamedCacheClient client = this.f_mapCaches.computeIfAbsent(sCacheName, k -> this.ensureCache(sCacheName));
        if (client.isActiveInternal()) {
            return client;
        }
        this.f_mapCaches.remove(sCacheName);
        return this.getAsyncCache(sCacheName, options);
    }

    protected <K, V> AsyncNamedCacheClient<K, V> ensureCache(String sCacheName) {
        Channel channel = this.f_tracingInterceptor == null ? this.f_channel : ClientInterceptors.intercept((Channel)this.f_channel, (ClientInterceptor[])new ClientInterceptor[]{this.f_tracingInterceptor});
        GrpcCacheLifecycleEventDispatcher dispatcher = new GrpcCacheLifecycleEventDispatcher(sCacheName, this);
        AsyncNamedCacheClient.DefaultDependencies deps = new AsyncNamedCacheClient.DefaultDependencies(sCacheName, channel, dispatcher);
        deps.setScope(this.f_sScopeName);
        deps.setSerializer(this.f_serializer, this.f_sSerializerFormat);
        deps.setExecutor(this.f_executor);
        AsyncNamedCacheClient client = new AsyncNamedCacheClient(deps);
        EventDispatcherRegistry dispatcherReg = (EventDispatcherRegistry)this.f_registry.getResource(EventDispatcherRegistry.class);
        if (dispatcherReg != null) {
            dispatcherReg.registerEventDispatcher((EventDispatcher)dispatcher);
        }
        this.f_executor.execute(() -> dispatcher.dispatchCacheCreated(client.getNamedCache()));
        client.addDeactivationListener(this.f_truncateListener);
        client.addDeactivationListener(this.f_deactivationListener);
        return client;
    }

    private class TruncateListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        private TruncateListener() {
        }

        public void entryUpdated(MapEvent evt) {
            NamedCache cacheEvent = (NamedCache)evt.getMap();
            AsyncNamedCacheClient<?, ?> client = GrpcRemoteSession.this.f_mapCaches.get(cacheEvent.getCacheName());
            if (client != null) {
                client.getEventDispatcher().dispatchCacheTruncated((NamedCache)evt.getMap());
            }
        }
    }

    private class ClientDeactivationListener<K, V>
    implements DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> {
        private ClientDeactivationListener() {
        }

        @Override
        public void released(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteSession.this.f_mapCaches.remove(client.getCacheName());
        }

        @Override
        public void destroyed(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteSession session = GrpcRemoteSession.this;
            AsyncNamedCacheClient<?, ?> removed = session.f_mapCaches.remove(client.getCacheName());
            if (removed != null) {
                GrpcCacheLifecycleEventDispatcher dispatcher = removed.getEventDispatcher();
                EventDispatcherRegistry dispatcherReg = (EventDispatcherRegistry)GrpcRemoteSession.this.f_registry.getResource(EventDispatcherRegistry.class);
                dispatcher.dispatchCacheDestroyed(removed.getNamedCache());
                dispatcherReg.unregisterEventDispatcher((EventDispatcher)removed.getEventDispatcher());
            }
        }
    }
}

