/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client.config;

import com.oracle.coherence.client.ChannelProvider;
import com.oracle.coherence.client.GrpcChannelConfigurer;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.builder.WrapperSocketAddressProviderBuilder;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.grpc.GrpcChannelDependencies;
import java.util.Optional;

public class DefaultGrpcChannelDependencies
implements GrpcChannelDependencies {
    private String m_sTarget;
    private SocketProviderBuilder m_builderSocketProvider;
    private ParameterizedBuilder<SocketAddressProvider> m_bldrAddressProviderRemote;
    private boolean m_fNameServiceAddressProvider = false;
    private String m_sOverrideAuthority;
    private String m_sLoadBalancerPolicy;
    private Expression<Seconds> m_expLoadBalancerTimeout = GrpcChannelDependencies.DEFAULT_LOAD_BALANCER_TIMEOUT;
    private ParameterizedBuilder<GrpcChannelConfigurer> m_configurerBuilder;
    private ParameterizedBuilder<ChannelProvider> m_bldrChannelProvider;

    public Optional<ChannelProvider> getChannelProvider() {
        if (this.m_bldrChannelProvider != null) {
            SystemPropertyParameterResolver resolver = new SystemPropertyParameterResolver();
            ChannelProvider provider = (ChannelProvider)this.m_bldrChannelProvider.realize((ParameterResolver)resolver, null, null);
            return Optional.ofNullable(provider);
        }
        return Optional.empty();
    }

    @Injectable(value="instance")
    public void setChannelProvider(ParameterizedBuilder<ChannelProvider> bldr) {
        this.m_bldrChannelProvider = bldr;
    }

    @Injectable
    public void setTarget(String sTarget) {
        this.m_sTarget = sTarget;
    }

    public String getTarget() {
        return this.m_sTarget;
    }

    public boolean isNameServiceAddressProvider() {
        return this.m_fNameServiceAddressProvider || this.m_bldrAddressProviderRemote == null;
    }

    @Injectable(value="name-service-addresses")
    public void setNameServiceAddressProviderBuilder(AddressProviderBuilder bldr) {
        this.setRemoteAddressProviderBuilder(bldr);
        this.m_fNameServiceAddressProvider = bldr != null;
    }

    @Injectable(value="remote-addresses")
    public void setRemoteAddressProviderBuilder(AddressProviderBuilder bldr) {
        this.m_bldrAddressProviderRemote = bldr == null ? null : new WrapperSocketAddressProviderBuilder(bldr);
        this.m_fNameServiceAddressProvider = false;
    }

    public ParameterizedBuilder<SocketAddressProvider> getRemoteAddressProviderBuilder() {
        return this.m_bldrAddressProviderRemote;
    }

    @Injectable
    public void setSocketProvider(SocketProviderBuilder builder) {
        this.m_builderSocketProvider = builder;
    }

    public SocketProviderBuilder getSocketProviderBuilder() {
        return this.m_builderSocketProvider;
    }

    @Injectable(value="override-authority")
    public void setOverrideAuthority(String sAuthority) {
        this.m_sOverrideAuthority = sAuthority;
    }

    public Optional<String> getAuthorityOverride() {
        return Optional.ofNullable(this.m_sOverrideAuthority);
    }

    @Injectable(value="load-balancer-policy")
    public void setLoadBalancerPolicy(String sPolicy) {
        this.m_sLoadBalancerPolicy = sPolicy;
    }

    public String getDefaultLoadBalancingPolicy() {
        String sPolicy = this.m_sLoadBalancerPolicy;
        if (sPolicy == null || sPolicy.isBlank()) {
            this.m_sLoadBalancerPolicy = "round_robin";
            sPolicy = "round_robin";
        }
        return sPolicy;
    }

    @Injectable(value="load-balancer-timeout")
    public void setLoadBalancerTimeout(Expression<Seconds> expr) {
        this.m_expLoadBalancerTimeout = expr == null ? GrpcChannelDependencies.DEFAULT_LOAD_BALANCER_TIMEOUT : expr;
    }

    public long getLoadBalancerTimeout(ParameterResolver resolver) {
        Seconds seconds = (Seconds)this.m_expLoadBalancerTimeout.evaluate(resolver);
        if (seconds == null) {
            seconds = (Seconds)GrpcChannelDependencies.DEFAULT_LOAD_BALANCER_TIMEOUT.evaluate(resolver);
        }
        return seconds.get();
    }

    @Injectable(value="configurer")
    public void setConfigurer(ParameterizedBuilder<GrpcChannelConfigurer> bldr) {
        this.m_configurerBuilder = bldr;
    }

    public Optional<GrpcChannelConfigurer> getConfigurer() {
        if (this.m_configurerBuilder != null) {
            SystemPropertyParameterResolver resolver = new SystemPropertyParameterResolver();
            SimpleParameterList parameters = new SimpleParameterList();
            GrpcChannelConfigurer configurer = (GrpcChannelConfigurer)this.m_configurerBuilder.realize((ParameterResolver)resolver, null, (ParameterList)parameters);
            return Optional.ofNullable(configurer);
        }
        return Optional.empty();
    }
}

