/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.AsyncNamedCacheClient;
import com.oracle.coherence.client.RemoteCollection;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.util.Extractors;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.PagedIterator;
import com.tangosol.util.ValueExtractor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class RemoteValues<K, V>
extends RemoteCollection<K, V, V>
implements Collection<V> {
    protected RemoteValues(AsyncNamedCacheClient<K, V> client) {
        super(client);
    }

    @Override
    public boolean contains(Object value) {
        try {
            return this.getCache().containsValue(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new ValuesIterator(this.getCache());
    }

    @Override
    public boolean remove(Object value) {
        Filter filter;
        AsyncNamedCacheClient cache = this.getCache();
        InvocableMap.Entry entry = cache.stream(filter = Filters.equal((ValueExtractor)Extractors.identity(), (Object)value)).findFirst().orElse(null);
        if (entry == null) {
            return false;
        }
        return cache.remove(entry.getKey()) != null;
    }

    @Override
    public Object[] toArray() {
        try {
            return ((Collection)this.getCache().values(Filters.always()).get()).toArray();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public <T1> T1[] toArray(T1[] array) {
        try {
            return ((Collection)this.getCache().values(Filters.always()).get()).toArray(array);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    protected static class ValuesIterator<K, V>
    implements Iterator<V> {
        protected final AsyncNamedCacheClient<K, V> f_client;
        protected final Iterator<Map.Entry<K, V>> f_iterator;
        protected Map.Entry<K, V> m_currentEntry;

        protected ValuesIterator(AsyncNamedCacheClient<K, V> client) {
            this.f_client = client;
            this.f_iterator = new PagedIterator(new RemoteCollection.EntryAdvancer<K, V>(client));
        }

        @Override
        public boolean hasNext() {
            return this.f_iterator.hasNext();
        }

        @Override
        public V next() {
            this.m_currentEntry = this.f_iterator.next();
            return this.m_currentEntry.getValue();
        }

        @Override
        public void remove() {
            try {
                this.f_client.remove(this.m_currentEntry.getKey()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RequestIncompleteException((Throwable)e);
            }
        }
    }
}

