/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client;

import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.cdi.Scope;
import com.oracle.coherence.common.util.Options;
import com.oracle.coherence.grpc.client.GrpcRemoteSession;
import com.tangosol.net.Session;
import com.tangosol.net.SessionProvider;
import io.helidon.config.Config;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class RemoteSessions
implements SessionProvider {
    protected final Map<String, Map<String, GrpcRemoteSession>> f_mapSessions = new ConcurrentHashMap<String, Map<String, GrpcRemoteSession>>();
    protected final BeanManager f_beanManager;
    protected final Config f_config;
    protected static RemoteSessions s_instance;

    protected RemoteSessions() {
        this(null, Config.create());
    }

    @Inject
    protected RemoteSessions(BeanManager beanManager, Config config) {
        this.f_beanManager = beanManager;
        this.f_config = config == null ? Config.empty() : config;
    }

    public GrpcRemoteSession createSession(Session.Option ... options) {
        Options sessionOptions = Options.from(Session.Option.class, (Object[])options);
        String sName = ((NameOption)sessionOptions.get(NameOption.class, (Object)NameOption.DEFAULT)).getName();
        String sScope = ((ScopeOption)sessionOptions.get(ScopeOption.class, (Object)ScopeOption.DEFAULT)).getScope();
        return this.ensureSession(sName, sScope);
    }

    public static synchronized RemoteSessions instance() {
        if (s_instance == null) {
            try {
                s_instance = (RemoteSessions)CDI.current().getBeanManager().createInstance().select(RemoteSessions.class, new Annotation[0]).get();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (s_instance == null) {
                s_instance = new RemoteSessions();
            }
        }
        return s_instance;
    }

    @PreDestroy
    public void shutdown() {
        for (Map<String, GrpcRemoteSession> map : this.f_mapSessions.values()) {
            Iterator<Map.Entry<String, GrpcRemoteSession>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, GrpcRemoteSession> entry = iterator.next();
                try {
                    entry.getValue().close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                iterator.remove();
            }
        }
    }

    public static Session.Option scope(String scope) {
        return scope == null ? ScopeOption.DEFAULT : new ScopeOption(scope);
    }

    @Produces
    @Remote
    @Scope
    protected GrpcRemoteSession getSession(InjectionPoint injectionPoint) {
        String sName = injectionPoint.getQualifiers().stream().filter(q -> q.annotationType().isAssignableFrom(Remote.class)).map(q -> ((Remote)q).value().trim()).findFirst().orElse("default");
        String sScope = injectionPoint.getQualifiers().stream().filter(q -> q.annotationType().isAssignableFrom(Scope.class)).map(q -> ((Scope)q).value().trim()).findFirst().orElse("");
        return this.ensureSession(sName, sScope);
    }

    GrpcRemoteSession ensureSession(String sName, String sScope) {
        Map map = this.f_mapSessions.computeIfAbsent(sScope, k -> new ConcurrentHashMap());
        GrpcRemoteSession session = map.computeIfAbsent(sName, k -> GrpcRemoteSession.builder(this.f_config).name(sName).scope(sScope).beanManager(this.f_beanManager).build());
        if (session.isClosed()) {
            map.remove(sName);
            return this.ensureSession(sName, sScope);
        }
        return session;
    }

    protected static class ScopeOption
    implements Session.Option {
        protected static final ScopeOption DEFAULT = new ScopeOption("");
        protected final String f_sScope;

        protected ScopeOption(String sScope) {
            this.f_sScope = sScope == null ? "" : sScope;
        }

        protected String getScope() {
            return this.f_sScope;
        }
    }

    protected static class NameOption
    implements Session.Option {
        protected static final NameOption DEFAULT = new NameOption("default");
        protected final String f_sName;

        protected NameOption(String sName) {
            this.f_sName = sName;
        }

        protected String getName() {
            return this.f_sName == null || this.f_sName.isEmpty() ? DEFAULT.getName() : this.f_sName;
        }
    }
}

