/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client;

import com.tangosol.internal.util.DaemonPool;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Controllable;
import io.helidon.config.Config;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class DaemonPoolExecutor
implements Executor,
Controllable {
    static final String CONFIG_THREAD_COUNT = "thread_count";
    static final String CONFIG_THREAD_COUNT_MIN = "thread_count_min";
    static final String CONFIG_THREAD_COUNT_MAX = "thread_count_max";
    protected final DaemonPool f_pool;

    protected DaemonPoolExecutor(DaemonPool pool) {
        this.f_pool = pool;
    }

    protected static DaemonPoolExecutor create() {
        return DaemonPoolExecutor.create(Config.empty());
    }

    protected static DaemonPoolExecutor create(Config config) {
        return DaemonPoolExecutor.builder(config).build();
    }

    protected static Builder builder() {
        return DaemonPoolExecutor.builder(Config.empty());
    }

    protected static Builder builder(Config config) {
        return new Builder(config);
    }

    @Override
    public void execute(Runnable command) {
        this.f_pool.add(command);
    }

    public void configure(XmlElement xmlElement) {
        this.f_pool.configure(xmlElement);
    }

    public void start() {
        this.f_pool.start();
    }

    public boolean isRunning() {
        return this.f_pool.isRunning();
    }

    boolean isStuck() {
        return this.f_pool.isStuck();
    }

    public void shutdown() {
        this.f_pool.shutdown();
    }

    public void stop() {
        this.f_pool.stop();
    }

    public ClassLoader getContextClassLoader() {
        return this.f_pool.getContextClassLoader();
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.f_pool.setContextClassLoader(loader);
    }

    public static class Builder
    implements io.helidon.common.Builder<DaemonPoolExecutor> {
        private final Config f_config;
        private Optional<String> m_optName = Optional.empty();
        private Optional<Function<DaemonPoolDependencies, DaemonPool>> m_optSupplier = Optional.empty();

        protected Builder(Config config) {
            this.f_config = config;
        }

        public Builder name(String name) {
            this.m_optName = Optional.ofNullable(name);
            return this;
        }

        public Builder supplier(Function<DaemonPoolDependencies, DaemonPool> supplier) {
            this.m_optSupplier = Optional.ofNullable(supplier);
            return this;
        }

        public DaemonPoolExecutor build() {
            DefaultDaemonPoolDependencies dependencies = new DefaultDaemonPoolDependencies();
            dependencies.setThreadCount(1);
            this.m_optName.ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setName(arg_0));
            this.f_config.get(DaemonPoolExecutor.CONFIG_THREAD_COUNT).asInt().ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setThreadCount(arg_0));
            this.f_config.get(DaemonPoolExecutor.CONFIG_THREAD_COUNT_MIN).asInt().ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setThreadCountMin(arg_0));
            this.f_config.get(DaemonPoolExecutor.CONFIG_THREAD_COUNT_MAX).asInt().ifPresent(arg_0 -> ((DefaultDaemonPoolDependencies)dependencies).setThreadCountMax(arg_0));
            DaemonPool pool = this.m_optSupplier.orElse(Daemons::newDaemonPool).apply((DaemonPoolDependencies)dependencies);
            return new DaemonPoolExecutor(pool);
        }
    }
}

