/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client;

import com.oracle.coherence.cdi.RemoteMapLifecycleEvent;
import com.oracle.coherence.cdi.SerializerProducer;
import com.oracle.coherence.grpc.client.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.client.DaemonPoolExecutor;
import com.oracle.coherence.grpc.client.DeactivationListener;
import com.oracle.coherence.grpc.client.GrpcChannelBuilder;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Base;
import com.tangosol.util.MapEvent;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.helidon.config.Config;
import io.helidon.grpc.client.ClientTracingInterceptor;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;

public class GrpcRemoteSession
implements Session {
    public static final String CFG_KEY_COHERENCE = "coherence";
    private final String f_sName;
    private final String f_sScopeName;
    private final ManagedChannel f_channel;
    private final Serializer f_serializer;
    private final String f_sSerializerFormat;
    private final BeanManager f_beanManager;
    private final RemoteMapLifecycleEvent.Dispatcher f_lifecycleEventDispatcher;
    private final Map<String, AsyncNamedCacheClient<?, ?>> f_mapCaches;
    private final ClientDeactivationListener f_deactivationListener;
    private final TruncateListener f_truncateListener;
    protected final List<DeactivationListener<GrpcRemoteSession>> f_listDeactivationListeners = new ArrayList<DeactivationListener<GrpcRemoteSession>>();
    protected final Optional<ClientTracingInterceptor> f_tracing;
    protected boolean m_fClosed;
    protected Executor m_executor;

    protected GrpcRemoteSession(Builder builder, BeanManager beanManager) {
        this.f_beanManager = beanManager;
        this.f_sName = builder.name();
        this.f_sScopeName = builder.scope();
        this.f_channel = builder.ensureChannel();
        this.f_sSerializerFormat = builder.ensureSerializerFormat();
        this.f_serializer = builder.ensureSerializer(this.f_sSerializerFormat);
        this.m_executor = builder.ensureExecutor();
        this.f_tracing = builder.ensureTracing();
        this.f_mapCaches = new ConcurrentHashMap();
        this.f_deactivationListener = new ClientDeactivationListener();
        this.f_truncateListener = new TruncateListener();
        Instance instance = null;
        if (beanManager != null) {
            Instance in = beanManager.createInstance();
            instance = in == null ? null : in.select(RemoteMapLifecycleEvent.Dispatcher.class, new Annotation[0]);
        }
        this.f_lifecycleEventDispatcher = instance != null && instance.isResolvable() ? (RemoteMapLifecycleEvent.Dispatcher)instance.get() : RemoteMapLifecycleEvent.Dispatcher.nullImplementation();
    }

    public String getName() {
        return this.f_sName;
    }

    public String getScope() {
        return this.f_sScopeName;
    }

    public static GrpcRemoteSession create() {
        return GrpcRemoteSession.builder().build();
    }

    public static Builder builder() {
        return new Builder(Config.empty());
    }

    public static Builder builder(Config config) {
        if (config == null) {
            config = Config.empty();
        }
        return new Builder(config);
    }

    public String scope() {
        return this.f_sScopeName;
    }

    public synchronized void addDeactivationListener(DeactivationListener<GrpcRemoteSession> listener) {
        Objects.requireNonNull(listener);
        if (!this.m_fClosed) {
            this.f_listDeactivationListeners.add(listener);
        } else {
            listener.destroyed(this);
        }
    }

    public synchronized void removeDeactivationListener(DeactivationListener<GrpcRemoteSession> listener) {
        this.f_listDeactivationListeners.remove(listener);
    }

    public String toString() {
        return "RemoteSession{scope: \"" + this.f_sScopeName + '\"' + ", serializerFormat \"" + this.f_sSerializerFormat + '\"' + ", closed: " + this.m_fClosed + '}';
    }

    public <K, V> NamedMap<K, V> getMap(String sName, NamedMap.Option ... options) {
        return this.getCache(sName, options);
    }

    public <K, V> NamedCache<K, V> getCache(String cacheName, NamedMap.Option ... options) {
        if (this.m_fClosed) {
            throw new IllegalStateException("this session has been closed");
        }
        return this.getAsyncCache(cacheName, options).getNamedCache();
    }

    public <V> NamedTopic<V> getTopic(String sName, NamedCollection.Option ... options) {
        throw new UnsupportedOperationException();
    }

    public synchronized void close() {
        this.m_fClosed = true;
        for (AsyncNamedCacheClient<?, ?> asyncNamedCacheClient : this.f_mapCaches.values()) {
            asyncNamedCacheClient.removeDeactivationListener(this.f_deactivationListener);
            try {
                asyncNamedCacheClient.release();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.f_mapCaches.clear();
        for (DeactivationListener deactivationListener : this.f_listDeactivationListeners) {
            try {
                deactivationListener.destroyed(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.f_listDeactivationListeners.clear();
    }

    public boolean isClosed() {
        return this.m_fClosed;
    }

    protected ManagedChannel getChannel() {
        return this.f_channel;
    }

    protected Serializer getSerializer() {
        return this.f_serializer;
    }

    protected String getSerializerFormat() {
        return this.f_sSerializerFormat;
    }

    protected BeanManager getBeanManager() {
        return this.f_beanManager;
    }

    protected synchronized <K, V> AsyncNamedCacheClient<K, V> getAsyncCache(String sCacheName, NamedMap.Option ... options) {
        AsyncNamedCacheClient client = this.f_mapCaches.computeIfAbsent(sCacheName, k -> this.ensureCache(sCacheName));
        if (client.isActiveInternal()) {
            return client;
        }
        this.f_mapCaches.remove(sCacheName);
        return this.getAsyncCache(sCacheName, options);
    }

    protected <K, V> AsyncNamedCacheClient<K, V> ensureCache(String sCacheName) {
        Channel tracedChannel = this.f_tracing.map(t -> t.intercept((Channel)this.f_channel)).orElse((Channel)this.f_channel);
        Object client = AsyncNamedCacheClient.builder(this.f_sScopeName, sCacheName).channel(tracedChannel).serializer(this.f_serializer, this.f_sSerializerFormat).beanManager(this.f_beanManager).executor(this.m_executor).build();
        this.f_lifecycleEventDispatcher.dispatch(((AsyncNamedCacheClient)client).getNamedMap(), this.f_sScopeName, this.f_sName, null, RemoteMapLifecycleEvent.Type.Created);
        ((AsyncNamedCacheClient)client).addDeactivationListener(this.f_truncateListener);
        ((AsyncNamedCacheClient)client).addDeactivationListener(this.f_deactivationListener);
        return client;
    }

    public static interface SessionDeactivationListener
    extends DeactivationListener<GrpcRemoteSession> {
        @Override
        default public void released(GrpcRemoteSession resource) {
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<GrpcRemoteSession> {
        protected static Optional<BeanManager> defaultBeanManager;
        protected String m_sName;
        protected String m_sScopeName;
        protected String m_sChannelName;
        protected ManagedChannel m_channel;
        protected Serializer m_serializer;
        protected String m_sSerializerFormat;
        protected BeanManager m_beanManager;
        protected Executor m_executor;
        protected final Config f_config;

        private Builder(Config config) {
            this.f_config = config;
            this.m_sName = "default";
            this.m_sChannelName = "default";
            this.m_beanManager = this.ensureBeanManager();
        }

        public Builder name(String name) {
            this.m_sName = name;
            return this;
        }

        public Builder scope(String name) {
            this.m_sScopeName = name;
            return this;
        }

        public Builder channelName(String name) {
            this.m_sChannelName = name;
            this.m_channel = null;
            return this;
        }

        public Builder channel(ManagedChannel channel) {
            this.m_channel = channel;
            this.m_sChannelName = null;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            return this.serializer(serializer, serializer.getName());
        }

        public Builder serializer(String format) {
            return this.serializer(null, format);
        }

        public Builder serializer(Serializer serializer, String format) {
            this.m_serializer = serializer;
            this.m_sSerializerFormat = format;
            if (this.m_sSerializerFormat == null && serializer != null) {
                this.m_sSerializerFormat = serializer.getName();
                if (this.m_sSerializerFormat == null) {
                    if (serializer instanceof DefaultSerializer) {
                        this.m_sSerializerFormat = "java";
                    } else if (serializer instanceof ConfigurablePofContext) {
                        this.m_sSerializerFormat = "pof";
                    }
                }
            }
            return this;
        }

        public Builder beanManager(BeanManager beanManager) {
            this.m_beanManager = beanManager;
            return this;
        }

        public Builder eventDispatcher(Executor executor) {
            this.m_executor = executor;
            return this;
        }

        public GrpcRemoteSession build() {
            return new GrpcRemoteSession(this, this.m_beanManager);
        }

        protected Config sessionConfig() {
            String sName = this.name();
            Config cfgSessions = this.f_config.get(GrpcRemoteSession.CFG_KEY_COHERENCE).get("sessions");
            if (!cfgSessions.exists()) {
                return Config.empty();
            }
            Config cfg = cfgSessions.get(sName);
            if (!cfg.exists()) {
                for (Config cfgNode : (List)cfgSessions.asNodeList().get()) {
                    Config cfgName = cfgNode.get("name");
                    if (!cfgName.exists() || !((String)cfgName.asString().get()).equals(sName)) continue;
                    cfg = cfgNode;
                    break;
                }
            }
            return cfg;
        }

        protected String name() {
            return this.m_sName == null || this.m_sName.isEmpty() ? "default" : this.m_sName;
        }

        protected String scope() {
            if (this.m_sScopeName == null) {
                return (String)this.sessionConfig().get("scope").asString().orElse((Object)"");
            }
            return this.m_sScopeName;
        }

        protected ManagedChannel ensureChannel() {
            Config sessionConfig = this.sessionConfig();
            if (this.m_channel != null) {
                return this.m_channel;
            }
            String channel = this.m_sChannelName;
            if (this.m_sChannelName == null || this.m_sChannelName.isEmpty()) {
                channel = (String)sessionConfig.get("channel").asString().orElse((Object)"default");
            }
            return GrpcChannelBuilder.builder(this.f_config).build().channel(channel);
        }

        protected Optional<ClientTracingInterceptor> ensureTracing() {
            Config sessionConfig = this.sessionConfig();
            Config config = sessionConfig.get("tracing");
            if (((Boolean)config.get("enabled").asBoolean().orElse((Object)false)).booleanValue()) {
                Tracer tracer = GlobalTracer.get();
                ClientTracingInterceptor.Builder builder = ClientTracingInterceptor.builder((Tracer)tracer);
                if (((Boolean)config.get("verbose").asBoolean().orElse((Object)true)).booleanValue()) {
                    builder.withVerbosity();
                }
                if (((Boolean)config.get("streaming").asBoolean().orElse((Object)true)).booleanValue()) {
                    builder.withStreaming();
                }
                return Optional.of(builder.build());
            }
            return Optional.empty();
        }

        protected String ensureSerializerFormat() {
            Config sessionConfig = this.sessionConfig();
            if (this.m_sSerializerFormat != null && !this.m_sSerializerFormat.isEmpty()) {
                return this.m_sSerializerFormat;
            }
            return (String)sessionConfig.get("serializer").asString().orElseGet(() -> Boolean.getBoolean("coherence.pof.enabled") ? "pof" : "java");
        }

        protected Serializer ensureSerializer(String format) {
            if (this.m_serializer != null) {
                return this.m_serializer;
            }
            return SerializerProducer.builder().beanManager(this.m_beanManager).build().getNamedSerializer(format, Base.getContextClassLoader());
        }

        protected BeanManager ensureBeanManager() {
            if (defaultBeanManager == null) {
                try {
                    BeanManager bm = CDI.current().getBeanManager();
                    defaultBeanManager = Optional.ofNullable(bm);
                }
                catch (Exception e) {
                    defaultBeanManager = Optional.empty();
                }
            }
            return defaultBeanManager.orElse(null);
        }

        Executor ensureExecutor() {
            if (this.m_executor == null) {
                Config config = this.sessionConfig().get("executor");
                DaemonPoolExecutor pool = DaemonPoolExecutor.builder(config).name(this.name()).build();
                pool.start();
                this.m_executor = pool;
            }
            return this.m_executor;
        }
    }

    private class TruncateListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        private TruncateListener() {
        }

        public void entryUpdated(MapEvent evt) {
            GrpcRemoteSession.this.f_lifecycleEventDispatcher.dispatch((NamedMap)evt.getMap(), GrpcRemoteSession.this.f_sScopeName, GrpcRemoteSession.this.f_sName, null, RemoteMapLifecycleEvent.Type.Truncated);
        }
    }

    private class ClientDeactivationListener<K, V>
    implements DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> {
        private ClientDeactivationListener() {
        }

        @Override
        public void released(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteSession.this.f_mapCaches.remove(client.getCacheName());
        }

        @Override
        public void destroyed(AsyncNamedCacheClient<? super K, ? super V> client) {
            AsyncNamedCacheClient removed = (AsyncNamedCacheClient)GrpcRemoteSession.this.f_mapCaches.remove(client.getCacheName());
            if (removed != null) {
                GrpcRemoteSession.this.f_lifecycleEventDispatcher.dispatch(removed.getNamedMap(), GrpcRemoteSession.this.f_sScopeName, GrpcRemoteSession.this.f_sName, null, RemoteMapLifecycleEvent.Type.Destroyed);
            }
        }
    }
}

