/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.grpc.proxy.ConfigurableCacheFactorySuppliers;
import com.oracle.coherence.grpc.proxy.DaemonPoolExecutor;
import com.oracle.coherence.grpc.proxy.GrpcProxyMetrics;
import com.oracle.coherence.grpc.proxy.GrpcServiceDependencies;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.net.management.Registry;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;

public class BaseGrpcServiceImpl {
    protected static final Void VOID = null;
    public static final long DEFAULT_TRANSFER_THRESHOLD = 524288L;
    protected final Dependencies f_dependencies;
    protected final Function<String, ConfigurableCacheFactory> f_cacheFactorySupplier;
    protected final NamedSerializerFactory f_serializerProducer;
    protected final Executor f_executor;
    protected final GrpcProxyMetrics f_metrics;
    private final ScopedReferenceStore<Serializer> f_storeSerializer;
    protected long transferThreshold = 524288L;

    public BaseGrpcServiceImpl(Dependencies dependencies, String sMBeanName, String sPoolName) {
        this.f_dependencies = dependencies;
        this.f_executor = dependencies.getExecutor().orElseGet(() -> BaseGrpcServiceImpl.createDefaultExecutor(sPoolName));
        this.f_cacheFactorySupplier = dependencies.getCacheFactorySupplier().orElse(ConfigurableCacheFactorySuppliers.DEFAULT);
        this.f_serializerProducer = dependencies.getNamedSerializerFactory().orElse(NamedSerializerFactory.DEFAULT);
        this.f_storeSerializer = new ScopedReferenceStore(Serializer.class, s -> true, Serializer::getName, s -> null);
        dependencies.getTransferThreshold().ifPresent(this::setTransferThreshold);
        DaemonPoolExecutor.DaemonPoolManagement management = this.f_executor instanceof DaemonPoolExecutor ? ((DaemonPoolExecutor)this.f_executor).getManagement() : null;
        Registry registry = dependencies.getRegistry().orElseGet(() -> CacheFactory.getCluster().getManagement());
        this.f_metrics = new GrpcProxyMetrics(sMBeanName, management);
        this.f_metrics.registerMBean(registry);
    }

    public GrpcProxyMetrics getMetrics() {
        return this.f_metrics;
    }

    long getTransferThreshold() {
        return this.transferThreshold;
    }

    void setTransferThreshold(long lSize) {
        this.transferThreshold = lSize;
    }

    protected static Executor createDefaultExecutor(String sName) {
        DefaultDaemonPoolDependencies deps = new DefaultDaemonPoolDependencies();
        deps.setName(sName);
        deps.setThreadCountMin(1);
        deps.setThreadCount(1);
        deps.setThreadCountMax(Integer.MAX_VALUE);
        DaemonPoolExecutor executor = DaemonPoolExecutor.newInstance(deps);
        executor.start();
        return executor;
    }

    protected Serializer getSerializer(String sFormatRequest, String sFormatProxy, Supplier<Serializer> supplierSerializer, Supplier<ClassLoader> supplierLoader) {
        Serializer serializer;
        if (sFormatRequest == null || sFormatRequest.trim().isEmpty() || sFormatRequest.equals(sFormatProxy)) {
            serializer = supplierSerializer.get();
        } else {
            ClassLoader loader = supplierLoader.get();
            serializer = (Serializer)this.f_storeSerializer.get(sFormatRequest, loader);
            if (serializer == null) {
                serializer = this.f_dependencies.getContext().map(c -> c.getNamedSerializer(sFormatRequest)).orElse(null);
            }
            if (serializer == null) {
                serializer = this.f_serializerProducer.getNamedSerializer(sFormatRequest, loader);
            }
            if (serializer != null) {
                this.f_storeSerializer.put((Object)serializer, loader);
            }
        }
        if (serializer == null) {
            throw Status.INVALID_ARGUMENT.withDescription("invalid request format, cannot find serializer with name '" + sFormatRequest + "'").asRuntimeException();
        }
        return serializer;
    }

    public static interface Dependencies
    extends GrpcServiceDependencies {
        public Optional<Function<String, ConfigurableCacheFactory>> getCacheFactorySupplier();
    }

    public static class DefaultDependencies
    extends GrpcServiceDependencies.DefaultDependencies
    implements Dependencies {
        private Function<String, ConfigurableCacheFactory> m_ccfSupplier;

        public DefaultDependencies() {
        }

        public DefaultDependencies(GrpcServiceDependencies deps) {
            super(deps);
        }

        public DefaultDependencies(Dependencies deps) {
            super(deps);
            if (deps != null) {
                this.m_ccfSupplier = deps.getCacheFactorySupplier().orElse(null);
            }
        }

        @Override
        public Optional<Function<String, ConfigurableCacheFactory>> getCacheFactorySupplier() {
            return Optional.ofNullable(this.m_ccfSupplier);
        }

        public void setConfigurableCacheFactorySupplier(Function<String, ConfigurableCacheFactory> ccfSupplier) {
            this.m_ccfSupplier = ccfSupplier;
        }
    }
}

